/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToCharFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleCharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableDoubleCharMap;
import com.gs.collections.api.map.primitive.DoubleCharMap;
import com.gs.collections.api.map.primitive.MutableDoubleCharMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.DoubleCharPair;
import com.gs.collections.impl.factory.primitive.DoubleCharMaps;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableDoubleCharMap
        implements MutableDoubleCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleCharMap map;

    UnmodifiableDoubleCharMap(MutableDoubleCharMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(char result, double key)
    {
        return result == DoubleCharHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private char getIfAbsentThrow(double key)
    {
        char result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, char value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleCharMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public char removeKeyIfAbsent(double key, char value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public char getIfAbsentPut(double key, char value)
    {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPut(double key, CharFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPutWithKey(double key, DoubleToCharFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> char getIfAbsentPutWith(double key, CharFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public char updateValue(double key, char initialValueIfAbsent, CharToCharFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public char get(double key)
    {
        return this.map.get(key);
    }

    public char getIfAbsent(double key, char ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(double key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(char value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleCharProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<DoubleCharPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableDoubleCharMap select(DoubleCharPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleCharMap reject(DoubleCharPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public CharIterator charIterator()
    {
        return this.map.charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public char max()
    {
        return this.map.max();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public char min()
    {
        return this.map.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public char addToValue(double key, char toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public char[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableCharList toSortedList()
    {
        return this.map.toSortedList();
    }

    public char[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(char value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableCharList toList()
    {
        return this.map.toList();
    }

    public MutableCharSet toSet()
    {
        return this.map.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.map.toBag();
    }

    public LazyCharIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableDoubleCharMap withKeyValue(double key, char value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCharMap withoutKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCharMap withoutAllKeys(DoubleIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCharMap asUnmodifiable()
    {
        return this;
    }

    public MutableDoubleCharMap asSynchronized()
    {
        return new SynchronizedDoubleCharMap(this);
    }

    public ImmutableDoubleCharMap toImmutable()
    {
        return DoubleCharMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.map.keySet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
