/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.util.Collections;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableObjectFloatMap;
import com.gs.collections.api.map.primitive.MutableObjectFloatMap;
import com.gs.collections.api.map.primitive.ObjectFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.ObjectFloatPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.primitive.ObjectFloatMaps;

/**
 * This file was automatically generated from template file unmodifiableObjectPrimitiveMap.stg.
 *
 * @since 3.2
 */
public final class UnmodifiableObjectFloatMap<K>
        implements MutableObjectFloatMap<K>, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectFloatMap<K> map;

    UnmodifiableObjectFloatMap(MutableObjectFloatMap<K> map)
    {
        this.map = map;
    }

    private boolean isAbsent(float result, K key)
    {
        return result == ObjectFloatHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private float getIfAbsentThrow(K key)
    {
        float result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, float value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectFloatMap<? extends K> map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(K key, float value)
    {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public float getIfAbsentPut(K key, float value)
    {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPut(K key, FloatFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float addToValue(K key, float toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public float get(Object key)
    {
        return this.map.get(key);
    }

    public float getOrThrow(Object key)
    {
        return this.map.getOrThrow(key);
    }

    public float getIfAbsent(Object key, float ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectFloatProcedure<? super K> procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> predicate)
    {
        return this.map.select(predicate);
    }

    public MutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> predicate)
    {
        return this.map.reject(predicate);
    }

    public FloatIterator floatIterator()
    {
        return this.map.floatIterator();
    }

    public void forEach(FloatProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatCollection select(FloatPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatCollection reject(FloatPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(FloatToObjectFunction<? extends V1> function)
    {
        return this.map.collect(function);
    }

    public double sum()
    {
        return this.map.sum();
    }

    public float max()
    {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min()
    {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public float[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return this.map.toSortedList();
    }

    public float[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(float value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList()
    {
        return this.map.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.map.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableObjectFloatMap<K> withKeyValue(K key, float value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> withoutKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> withoutAllKeys(Iterable<? extends K> keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> asUnmodifiable()
    {
        return this;
    }

    public MutableObjectFloatMap<K> asSynchronized()
    {
        return new SynchronizedObjectFloatMap<K>(this);
    }

    public ImmutableObjectFloatMap<K> toImmutable()
    {
        return ObjectFloatMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public Set<K> keySet()
    {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ObjectFloatPair<K>> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
