/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.util.Collections;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableObjectIntMap;
import com.gs.collections.api.map.primitive.MutableObjectIntMap;
import com.gs.collections.api.map.primitive.ObjectIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.primitive.ObjectIntMaps;

/**
 * This file was automatically generated from template file unmodifiableObjectPrimitiveMap.stg.
 *
 * @since 3.2
 */
public final class UnmodifiableObjectIntMap<K>
        implements MutableObjectIntMap<K>, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectIntMap<K> map;

    UnmodifiableObjectIntMap(MutableObjectIntMap<K> map)
    {
        this.map = map;
    }

    private boolean isAbsent(int result, K key)
    {
        return result == ObjectIntHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private int getIfAbsentThrow(K key)
    {
        int result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, int value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectIntMap<? extends K> map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int removeKeyIfAbsent(K key, int value)
    {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public int getIfAbsentPut(K key, int value)
    {
        return this.getIfAbsentThrow(key);
    }

    public int getIfAbsentPut(K key, IntFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public int getIfAbsentPutWithKey(K key, IntFunction<? super K> function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> int getIfAbsentPutWith(K key, IntFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public int updateValue(K key, int initialValueIfAbsent, IntToIntFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public int addToValue(K key, int toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public int get(Object key)
    {
        return this.map.get(key);
    }

    public int getOrThrow(Object key)
    {
        return this.map.getOrThrow(key);
    }

    public int getIfAbsent(Object key, int ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectIntMap<K> select(ObjectIntPredicate<? super K> predicate)
    {
        return this.map.select(predicate);
    }

    public MutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> predicate)
    {
        return this.map.reject(predicate);
    }

    public IntIterator intIterator()
    {
        return this.map.intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableIntCollection select(IntPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableIntCollection reject(IntPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(IntToObjectFunction<? extends V1> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public int max()
    {
        return this.map.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.map.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public int[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableIntList toSortedList()
    {
        return this.map.toSortedList();
    }

    public int[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(int value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.map.toList();
    }

    public MutableIntSet toSet()
    {
        return this.map.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.map.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableObjectIntMap<K> withKeyValue(K key, int value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectIntMap<K> withoutKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectIntMap<K> withoutAllKeys(Iterable<? extends K> keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectIntMap<K> asUnmodifiable()
    {
        return this;
    }

    public MutableObjectIntMap<K> asSynchronized()
    {
        return new SynchronizedObjectIntMap<K>(this);
    }

    public ImmutableObjectIntMap<K> toImmutable()
    {
        return ObjectIntMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public Set<K> keySet()
    {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ObjectIntPair<K>> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
