/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.ShortStack;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortEmptyStack is an optimization for {@link ImmutableShortStack} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyStack.stg.
 */
@Immutable
final class ImmutableShortEmptyStack implements ImmutableShortStack, Serializable
{
    static final ImmutableShortStack INSTANCE = new ImmutableShortEmptyStack();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ShortIterator shortIterator()
    {
        return new InternalShortIterator();
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public short peek()
    {
        throw new EmptyStackException();
    }

    public ShortList peek(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return new ShortArrayList(0);
        }
        throw new EmptyStackException();
    }

    public short peekAt(int index)
    {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableShortStack select(ShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortStack reject(ShortPredicate predicate)
    {
        return this;
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Stacks.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public short[] toArray()
    {
        return new short[0];
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(short... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public ImmutableShortStack toImmutable()
    {
        return this;
    }

    public ImmutableShortStack push(short element)
    {
        return ShortStacks.immutable.with(element);
    }

    public ImmutableShortStack pop()
    {
        throw new EmptyStackException();
    }

    public ImmutableShortStack pop(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack)
    {
        if (otherStack == this)
        {
            return true;
        }
        if (!(otherStack instanceof ShortStack))
        {
            return false;
        }
        ShortStack stack = (ShortStack) otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private static class InternalShortIterator implements ShortIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public short next()
        {
            throw new NoSuchElementException();
        }
    }
}
