/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableCharBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableCharEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableCharHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableCharSingletonBag;

public class ImmutableCharBagFactoryImpl
implements ImmutableCharBagFactory {
    public ImmutableCharBag of() {
        return this.with();
    }

    public ImmutableCharBag with() {
        return ImmutableCharEmptyBag.INSTANCE;
    }

    public ImmutableCharBag of(char one) {
        return this.with(one);
    }

    public ImmutableCharBag with(char one) {
        return new ImmutableCharSingletonBag(one);
    }

    public ImmutableCharBag of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharBag with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharHashBag.newBagWith(items);
    }

    public ImmutableCharBag ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharBag withAll(CharIterable items) {
        if (items instanceof ImmutableCharBag) {
            return (ImmutableCharBag)items;
        }
        return this.with(items.toArray());
    }
}

