/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableCharBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import com.gs.collections.impl.factory.primitive.CharBags;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedCharBag
extends AbstractSynchronizedCharCollection
implements MutableCharBag {
    private static final long serialVersionUID = 1L;

    SynchronizedCharBag(MutableCharBag bag) {
        super((MutableCharCollection)bag);
    }

    SynchronizedCharBag(MutableCharBag bag, Object newLock) {
        super((MutableCharCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableCharBag getMutableCharBag() {
        return (MutableCharBag)this.getCharCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag with(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag without(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag withAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag withoutAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(char item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(char item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(char item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(CharIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag select(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag reject(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyCharIterableAdapter((CharIterable)this);
        }
    }

    public MutableCharBag asUnmodifiable() {
        return new UnmodifiableCharBag(this);
    }

    public MutableCharBag asSynchronized() {
        return this;
    }

    public ImmutableCharBag toImmutable() {
        return CharBags.immutable.withAll((CharIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableCharBag().injectInto(injectedValue, function);
        }
    }
}

