/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableDoubleBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import com.gs.collections.impl.factory.primitive.DoubleBags;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedDoubleBag
extends AbstractSynchronizedDoubleCollection
implements MutableDoubleBag {
    private static final long serialVersionUID = 1L;

    SynchronizedDoubleBag(MutableDoubleBag bag) {
        super((MutableDoubleCollection)bag);
    }

    SynchronizedDoubleBag(MutableDoubleBag bag, Object newLock) {
        super((MutableDoubleCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableDoubleBag getMutableDoubleBag() {
        return (MutableDoubleBag)this.getDoubleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleBag with(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleBag without(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleBag withAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleBag withoutAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(double item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(double item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(double item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(DoubleIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag select(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag reject(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyDoubleIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }
    }

    public MutableDoubleBag asUnmodifiable() {
        return new UnmodifiableDoubleBag(this);
    }

    public MutableDoubleBag asSynchronized() {
        return this;
    }

    public ImmutableDoubleBag toImmutable() {
        return DoubleBags.immutable.withAll((DoubleIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableDoubleBag().injectInto(injectedValue, function);
        }
    }
}

