/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.EmptyIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class CompositeIterable<E>
extends AbstractLazyIterable<E> {
    private final MutableList<Iterable<E>> iterables;

    private CompositeIterable(MutableList<Iterable<E>> newIterables) {
        this.iterables = newIterables;
    }

    public CompositeIterable() {
        this(FastList.newList());
    }

    public static <T> CompositeIterable<T> with(Iterable<T> ... iterables) {
        return new CompositeIterable(FastList.newListWith(iterables));
    }

    public void forEach(final Procedure<? super E> procedure) {
        this.iterables.forEach(new Procedure<Iterable<E>>(){

            public void value(Iterable<E> iterable) {
                Iterate.forEach(iterable, procedure);
            }
        });
    }

    public void forEachWithIndex(final ObjectIntProcedure<? super E> objectIntProcedure) {
        final Counter index = new Counter();
        this.iterables.forEach(new Procedure<Iterable<E>>(){

            public void value(Iterable<E> iterable) {
                Iterate.forEach(iterable, new Procedure<E>(){

                    public void value(E object) {
                        objectIntProcedure.value(object, index.getCount());
                        index.increment();
                    }
                });
            }
        });
    }

    public <P> void forEachWith(final Procedure2<? super E, ? super P> procedure, final P parameter) {
        this.iterables.forEach(new Procedure<Iterable<E>>(){

            public void value(Iterable<E> iterable) {
                Iterate.forEachWith(iterable, procedure, parameter);
            }
        });
    }

    public void add(Iterable<E> iterable) {
        this.iterables.add(iterable);
    }

    public Iterator<E> iterator() {
        return new CompositeIterator(this.iterables);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompositeIterator
    implements Iterator<E> {
        private final Iterator<Iterable<E>> iterablesIterator;
        private Iterator<E> innerIterator;

        private CompositeIterator(MutableList<Iterable<E>> iterables) {
            this.iterablesIterator = iterables.listIterator();
            this.innerIterator = EmptyIterator.getInstance();
        }

        @Override
        public boolean hasNext() {
            while (!this.innerIterator.hasNext()) {
                if (!this.iterablesIterator.hasNext()) {
                    return false;
                }
                this.innerIterator = this.iterablesIterator.next().iterator();
            }
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.innerIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a composite iterator");
        }
    }
}

