/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.util.NoSuchElementException;

public class ReverseDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleList adapted;

    public ReverseDoubleIterable(DoubleList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseDoubleIterable adapt(DoubleList doubleList) {
        return new ReverseDoubleIterable(doubleList);
    }

    public DoubleIterator doubleIterator() {
        return new ReverseDoubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public double sum() {
        return this.adapted.sum();
    }

    public double max() {
        return this.adapted.max();
    }

    public double min() {
        return this.adapted.min();
    }

    public double minIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public double[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    public double[] toArray() {
        double[] results = new double[this.adapted.size()];
        int index = 0;
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(double value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    private class ReverseDoubleIterator
    implements DoubleIterator {
        private int currentIndex;

        private ReverseDoubleIterator() {
            this.currentIndex = ReverseDoubleIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double next = ReverseDoubleIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

