/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.immutable.AbstractImmutableList;
import java.io.Serializable;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableSingletonList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final T element1;

    ImmutableSingletonList(T obj1) {
        this.element1 = obj1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1);
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public T get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element1;
    }

    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.of(this.get(0), newItem);
    }
}

