/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedLongCollection;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseLongIterable;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableLongList;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedLongList
extends AbstractSynchronizedLongCollection
implements MutableLongList {
    private static final long serialVersionUID = 1L;

    SynchronizedLongList(MutableLongList list) {
        super((MutableLongCollection)list);
    }

    SynchronizedLongList(MutableLongList list, Object newLock) {
        super((MutableLongCollection)list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableLongList getMutableLongList() {
        return (MutableLongList)this.getLongCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(long value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(long value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtIndex(int index, long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, long ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, LongIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long set(int index, long element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList with(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList without(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList withAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList withoutAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList select(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList reject(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().sortThis();
        }
        return this;
    }

    public long dotProduct(LongList list) {
        return this.getMutableLongList().dotProduct(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLongIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyLongIterableAdapter((LongIterable)this);
        }
    }

    public MutableLongList asUnmodifiable() {
        return new UnmodifiableLongList(this);
    }

    public MutableLongList asSynchronized() {
        return this;
    }

    public ImmutableLongList toImmutable() {
        int size = this.size();
        if (size == 0) {
            return LongLists.immutable.with();
        }
        if (size == 1) {
            return LongLists.immutable.with(this.getFirst());
        }
        return LongLists.immutable.with(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().toReversed();
        }
    }

    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt((LongList)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(LongIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableLongList().injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableLongList().injectIntoWithIndex(injectedValue, function);
        }
    }

    public MutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

