/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.IntFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableIntFloatMap;
import com.gs.collections.api.map.primitive.IntFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.IntFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.immutable.primitive.ImmutableIntFloatSingletonMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyIntIterate;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntFloatEmptyMap
implements ImmutableIntFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    static final ImmutableIntFloatMap INSTANCE = new ImmutableIntFloatEmptyMap();

    ImmutableIntFloatEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public float get(int key) {
        return 0.0f;
    }

    public float getIfAbsent(int key, float ifAbsent) {
        return ifAbsent;
    }

    public float getOrThrow(int key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return false;
    }

    public boolean containsValue(float value) {
        return false;
    }

    public void forEachValue(FloatProcedure procedure) {
    }

    public void forEachKey(IntProcedure procedure) {
    }

    public void forEachKeyValue(IntFloatProcedure procedure) {
    }

    public LazyIntIterable keysView() {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntFloatPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableIntFloatMap select(IntFloatPredicate predicate) {
        return this;
    }

    public ImmutableIntFloatMap reject(IntFloatPredicate predicate) {
        return this;
    }

    public ImmutableIntFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public void forEach(FloatProcedure procedure) {
    }

    public int count(FloatPredicate predicate) {
        return 0;
    }

    public double sum() {
        return 0.0;
    }

    public float min() {
        throw new NoSuchElementException();
    }

    public float max() {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public float[] toSortedArray() {
        return new float[0];
    }

    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return FloatLists.immutable.with();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return FloatLists.immutable.with();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public float[] toArray() {
        return new float[0];
    }

    public boolean contains(float value) {
        return false;
    }

    public boolean containsAll(float ... source) {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableIntFloatMap newWithKeyValue(int key, float value) {
        return new ImmutableIntFloatSingletonMap(key, value);
    }

    public ImmutableIntFloatMap newWithoutKey(int key) {
        return this;
    }

    public ImmutableIntFloatMap newWithoutAllKeys(IntIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of((MutableFloatCollection)new FloatArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntFloatMap)) {
            return false;
        }
        IntFloatMap map = (IntFloatMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalFloatIterator
    implements FloatIterator {
        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public float next() {
            throw new NoSuchElementException();
        }
    }
}

