/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.ByteToIntFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteIntPredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ByteIntMap;
import com.gs.collections.api.map.primitive.ImmutableByteIntMap;
import com.gs.collections.api.map.primitive.MutableByteIntMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.ByteIntPair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteIntMaps;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteIntMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteIntMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteIntHashMap
implements MutableByteIntMap,
Externalizable {
    static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ByteIntHashMap() {
        this.allocateTable(16);
    }

    public ByteIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ByteIntHashMap(ByteIntMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ByteIntHashMap newWithKeysValues(byte key1, int value1) {
        return new ByteIntHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteIntHashMap newWithKeysValues(byte key1, int value1, byte key2, int value2) {
        return new ByteIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteIntHashMap newWithKeysValues(byte key1, int value1, byte key2, int value2, byte key3, int value3) {
        return new ByteIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteIntHashMap newWithKeysValues(byte key1, int value1, byte key2, int value2, byte key3, int value3, byte key4, int value4) {
        return new ByteIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteIntMap)) {
            return false;
        }
        ByteIntMap other = (ByteIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || this.sentinelValues.zeroValue != other.getOrThrow((byte)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || this.sentinelValues.oneValue != other.getOrThrow((byte)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                byte key = this.keys[i];
                if (!ByteIntHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(int ... source) {
        for (int each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        return source.allSatisfy(new IntPredicate(){

            public boolean accept(int value) {
                return ByteIntHashMap.this.contains(value);
            }
        });
    }

    public void forEach(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableIntCollection select(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntCollection reject(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, 0);
    }

    public void put(byte key, int value) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ByteIntMap map) {
        map.forEachKeyValue(new ByteIntProcedure(){

            public void value(byte key, int value) {
                ByteIntHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(byte key) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(byte key, int value) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(byte key, int value) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPut(byte key, IntFunction0 function) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> int getIfAbsentPutWith(byte key, IntFunction<? super P> function, P parameter) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.intValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.intValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPutWithKey(byte key, ByteToIntFunction function) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int addToValue(byte key, int toBeAdded) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(byte key, int value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(int value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = 0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(int value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = 0;
        } else {
            this.sentinelValues = null;
        }
    }

    public int updateValue(byte key, int initialValueIfAbsent, IntToIntFunction function) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ByteIntHashMap withKeyValue(byte key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteIntHashMap withKeysValues(byte key1, int value1, byte key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteIntHashMap withKeysValues(byte key1, int value1, byte key2, int value2, byte key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteIntHashMap withKeysValues(byte key1, int value1, byte key2, int value2, byte key3, int value3, byte key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteIntHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteIntHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteIntHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteIntMap asUnmodifiable() {
        return new UnmodifiableByteIntMap(this);
    }

    public MutableByteIntMap asSynchronized() {
        return new SynchronizedByteIntMap(this);
    }

    public ImmutableByteIntMap toImmutable() {
        return ByteIntMaps.immutable.ofAll((ByteIntMap)this);
    }

    public int get(byte key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(byte key, int ifAbsent) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public int getOrThrow(byte key) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        if (ByteIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(int value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (byte key : this.keys) {
            if (!ByteIntHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ByteIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ByteIntPair> keyValuesView() {
        return new KeyValuesView();
    }

    public ByteIntHashMap select(ByteIntPredicate predicate) {
        ByteIntHashMap result = new ByteIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteIntHashMap reject(ByteIntPredicate predicate) {
        ByteIntHashMap result = new ByteIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return element & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteIntHashMap.isEmptyKey(key) && !ByteIntHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ byte[] access$802(ByteIntHashMap x0, byte[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1002(ByteIntHashMap x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ByteIntPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super ByteIntPair> procedure) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ByteIntHashMap.this.sentinelValues.zeroValue));
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ByteIntHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteIntHashMap.this.keys[i], ByteIntHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super ByteIntPair> objectIntProcedure) {
            int index = 0;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)0, ByteIntHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)1, ByteIntHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ByteIntHashMap.this.keys[i], ByteIntHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super ByteIntPair, ? super P> procedure, P parameter) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ByteIntHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ByteIntHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteIntHashMap.this.keys[i], ByteIntHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ByteIntPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ByteIntPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteIntPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteIntHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ByteIntHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteIntHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ByteIntHashMap.this.sentinelValues.oneValue);
                    }
                }
                byte[] keys = ByteIntHashMap.this.keys;
                while (!ByteIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ByteIntPair result = PrimitiveTuples.pair(keys[this.position], ByteIntHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteIntHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableIntCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ByteIntHashMap.this.clear();
        }

        public MutableIntCollection select(IntPredicate predicate) {
            return ByteIntHashMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate) {
            return ByteIntHashMap.this.reject(predicate);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return ByteIntHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return ByteIntHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            return ByteIntHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return ByteIntHashMap.this.sum();
        }

        public int max() {
            return ByteIntHashMap.this.max();
        }

        public int maxIfEmpty(int defaultValue) {
            return ByteIntHashMap.this.maxIfEmpty(defaultValue);
        }

        public int min() {
            return ByteIntHashMap.this.min();
        }

        public int minIfEmpty(int defaultValue) {
            return ByteIntHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ByteIntHashMap.this.average();
        }

        public double median() {
            return ByteIntHashMap.this.median();
        }

        public int[] toSortedArray() {
            return ByteIntHashMap.this.toSortedArray();
        }

        public MutableIntList toSortedList() {
            return ByteIntHashMap.this.toSortedList();
        }

        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll((IntIterable)this);
        }

        public boolean contains(int value) {
            return ByteIntHashMap.this.containsValue(value);
        }

        public boolean containsAll(int ... source) {
            return ByteIntHashMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source) {
            return ByteIntHashMap.this.containsAll(source);
        }

        public MutableIntList toList() {
            return ByteIntHashMap.this.toList();
        }

        public MutableIntSet toSet() {
            return ByteIntHashMap.this.toSet();
        }

        public MutableIntBag toBag() {
            return ByteIntHashMap.this.toBag();
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public boolean isEmpty() {
            return ByteIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteIntHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteIntHashMap.this.sentinelValues != null) {
                    if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ByteIntHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ByteIntHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                    byte key = ByteIntHashMap.this.keys[i];
                    if (!ByteIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ByteIntHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return ByteIntHashMap.this.intIterator();
        }

        public void forEach(IntProcedure procedure) {
            ByteIntHashMap.this.forEach(procedure);
        }

        public int count(IntPredicate predicate) {
            return ByteIntHashMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate) {
            return ByteIntHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate) {
            return ByteIntHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return ByteIntHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(int item) {
            int oldSize = ByteIntHashMap.this.size();
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && item == ByteIntHashMap.this.sentinelValues.zeroValue) {
                    ByteIntHashMap.this.removeKey((byte)0);
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && item == ByteIntHashMap.this.sentinelValues.oneValue) {
                    ByteIntHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i]) || item != ByteIntHashMap.this.values[i]) continue;
                ByteIntHashMap.this.removeKey(ByteIntHashMap.this.keys[i]);
            }
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = ByteIntHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = ByteIntHashMap.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            ByteIntHashMap retained = ByteIntHashMap.this.select(new ByteIntPredicate((IntSet)sourceSet){
                final /* synthetic */ IntSet val$sourceSet;
                {
                    this.val$sourceSet = intSet;
                }

                public boolean accept(byte key, int value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ByteIntHashMap.access$802(ByteIntHashMap.this, retained.keys);
                ByteIntHashMap.access$1002(ByteIntHashMap.this, retained.values);
                ByteIntHashMap.this.sentinelValues = retained.sentinelValues;
                ByteIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll((IntIterable)IntHashSet.newSetWith(source));
        }

        public int size() {
            return ByteIntHashMap.this.size();
        }

        public int[] toArray() {
            return ByteIntHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableByteSet {
        private KeySet() {
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public void forEach(ByteProcedure procedure) {
            ByteIntHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(byte key) {
            int oldSize = ByteIntHashMap.this.size();
            ByteIntHashMap.this.removeKey(key);
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = ByteIntHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                ByteIntHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = ByteIntHashMap.this.size();
            for (byte item : source) {
                ByteIntHashMap.this.removeKey(item);
            }
            return oldSize != ByteIntHashMap.this.size();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteIntHashMap retained = ByteIntHashMap.this.select(new ByteIntPredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(byte key, int value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ByteIntHashMap.access$802(ByteIntHashMap.this, retained.keys);
                ByteIntHashMap.access$1002(ByteIntHashMap.this, retained.values);
                ByteIntHashMap.this.sentinelValues = retained.sentinelValues;
                ByteIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public void clear() {
            ByteIntHashMap.this.clear();
        }

        public MutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableByteSet without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableByteSet withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableByteSet withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((byte)0));
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((byte)1));
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableByteSet asUnmodifiable() {
            return UnmodifiableByteSet.of(this);
        }

        public MutableByteSet asSynchronized() {
            return SynchronizedByteSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (byte key : ByteIntHashMap.this.keys) {
                if (!ByteIntHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public byte max() {
            if (ByteIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max = 0;
            boolean isMaxSet = false;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i]) || isMaxSet && max >= ByteIntHashMap.this.keys[i]) continue;
                max = ByteIntHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (ByteIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public byte min() {
            if (ByteIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min = 0;
            boolean isMinSet = false;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i]) || isMinSet && ByteIntHashMap.this.keys[i] >= min) continue;
                min = ByteIntHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (ByteIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public byte[] toArray() {
            int size = ByteIntHashMap.this.size();
            final byte[] result = new byte[size];
            ByteIntHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(byte value) {
            return ByteIntHashMap.this.containsKey(value);
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (ByteIntHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (ByteIntHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (byte)0);
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (byte)1);
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ByteIntHashMap.this.keys[i]);
            }
            return result;
        }

        public ByteSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableByteSet toImmutable() {
            return ByteSets.immutable.withAll((ByteIterable)this);
        }

        public int size() {
            return ByteIntHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteIntHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ByteIntHashMap.this.sentinelValues != null) {
                if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ByteIntHashMap.this.keys.length; ++i) {
                if (!ByteIntHashMap.isNonSentinel(ByteIntHashMap.this.keys[i])) continue;
                result += ByteIntHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteIntHashMap.this.sentinelValues != null) {
                    if (ByteIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteIntHashMap.this.keys) {
                    if (!ByteIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteIntHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteIntHashMap.this.containsKey((byte)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteIntHashMap.this.containsKey((byte)1)) {
                    return 1;
                }
            }
            byte[] keys = ByteIntHashMap.this.keys;
            while (!ByteIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public void forEach(ByteProcedure procedure) {
            ByteIntHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteIntHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteIntHashMap.this.containsKey((byte)0)) {
                    return ByteIntHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteIntHashMap.this.containsKey((byte)1)) {
                    return ByteIntHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteIntHashMap.this.keys;
            while (!ByteIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = ByteIntHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private int zeroValue;
        private int oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(int value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

