/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntProcedure;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableIntSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private IntSet set;

    public ImmutableIntSetSerializationProxy() {
    }

    public ImmutableIntSetSerializationProxy(IntSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach((IntProcedure)new CheckedIntProcedure(){

                public void safeValue(int item) throws Exception {
                    out.writeInt(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        IntHashSet deserializedSet = new IntHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readInt());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

