/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.FileCopyUtils;
import com.googlecode.flyway.core.util.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathResource
implements Comparable<ClassPathResource>,
Resource {
    private String location;

    public ClassPathResource(String location) {
        this.location = location;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getLocationOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new FlywayException("Unable to location resource on disk: " + this.location);
        }
        try {
            return URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FlywayException("Unknown encoding: UTF-8", e);
        }
    }

    private URL getUrl() {
        return this.getClassLoader().getResource(this.location);
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public String loadAsString(String encoding) {
        try {
            InputStream inputStream = this.getClassLoader().getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.location);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(encoding));
            return FileCopyUtils.copyToString(reader);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.location + " (encoding: " + encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            InputStream inputStream = this.getClassLoader().getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.location);
            }
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.location, e);
        }
    }

    @Override
    public String getFilename() {
        return this.location.substring(this.location.lastIndexOf("/") + 1);
    }

    @Override
    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Override
    public int compareTo(ClassPathResource o) {
        return this.location.compareTo(o.location);
    }
}

