/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TableLink
extends Table {
    private static final int MAX_RETRY = 2;
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private final String originalSchema;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> preparedMap = New.hashMap();
    private final ArrayList<Index> indexes = New.arrayList();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private DbException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean storesMixedCaseQuoted;
    private boolean supportsMixedCaseIdentifiers;
    private boolean globalTemporary;
    private boolean readOnly;

    public TableLink(Schema schema, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        super(schema, n, string, false, true);
        this.driver = string2;
        this.url = string3;
        this.user = string4;
        this.password = string5;
        this.originalSchema = string6;
        this.originalTable = string7;
        this.emitUpdates = bl;
        try {
            this.connect();
        }
        catch (DbException dbException) {
            if (!bl2) {
                throw dbException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.linkedIndex = new LinkedIndex(this, n, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() {
        this.connectException = null;
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
                synchronized (tableLinkConnection) {
                    try {
                        this.readMetaData();
                        return;
                    }
                    catch (Exception exception) {
                        this.conn.close(true);
                        this.conn = null;
                        throw DbException.convert(exception);
                    }
                }
            }
            catch (DbException dbException) {
                if (n >= 2) {
                    this.connectException = dbException;
                    throw dbException;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    private void readMetaData() throws SQLException {
        Column column;
        int n;
        int n2;
        int n3;
        String string;
        Column[] columnArray;
        Object object;
        DatabaseMetaData databaseMetaData = this.conn.getConnection().getMetaData();
        this.storesLowerCase = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCase = databaseMetaData.storesMixedCaseIdentifiers();
        this.storesMixedCaseQuoted = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        ResultSet resultSet = databaseMetaData.getTables(null, this.originalSchema, this.originalTable, null);
        if (resultSet.next() && resultSet.next()) {
            throw DbException.get(90080, this.originalTable);
        }
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, this.originalSchema, this.originalTable, null);
        int n4 = 0;
        ArrayList<Column> arrayList = New.arrayList();
        HashMap<String, Column> hashMap = New.hashMap();
        String string2 = null;
        String string3 = null;
        while (resultSet.next()) {
            object = resultSet.getString("TABLE_CAT");
            if (string2 == null) {
                string2 = object;
            }
            columnArray = resultSet.getString("TABLE_SCHEM");
            if (string3 == null) {
                string3 = columnArray;
            }
            if (!StringUtils.equals(string2, (String)object) || !StringUtils.equals(string3, (String)columnArray)) {
                hashMap.clear();
                arrayList.clear();
                break;
            }
            string = resultSet.getString("COLUMN_NAME");
            string = this.convertColumnName(string);
            n3 = resultSet.getInt("DATA_TYPE");
            String string4 = resultSet.getString("TYPE_NAME");
            long l = resultSet.getInt("COLUMN_SIZE");
            l = TableLink.convertPrecision(n3, l);
            n2 = resultSet.getInt("DECIMAL_DIGITS");
            n2 = TableLink.convertScale(n3, n2);
            n = MathUtils.convertLongToInt(l);
            int n5 = DataType.convertSQLTypeToValueType(n3, string4);
            column = new Column(string, n5, l, n2, n);
            column.setTable(this, n4++);
            arrayList.add(column);
            hashMap.put(string, column);
        }
        resultSet.close();
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + "." + this.originalTable : this.originalTable;
        object = null;
        try {
            object = this.conn.getConnection().createStatement();
            resultSet = object.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
            if (arrayList.size() == 0) {
                columnArray = resultSet.getMetaData();
                n4 = 0;
                while (n4 < columnArray.getColumnCount()) {
                    string = columnArray.getColumnName(n4 + 1);
                    string = this.convertColumnName(string);
                    n3 = columnArray.getColumnType(n4 + 1);
                    long l = columnArray.getPrecision(n4 + 1);
                    l = TableLink.convertPrecision(n3, l);
                    int n6 = columnArray.getScale(n4 + 1);
                    n6 = TableLink.convertScale(n3, n6);
                    n2 = columnArray.getColumnDisplaySize(n4 + 1);
                    n = DataType.getValueTypeFromResultSet((ResultSetMetaData)columnArray, n4 + 1);
                    Column column2 = new Column(string, n, l, n6, n2);
                    column2.setTable(this, n4++);
                    arrayList.add(column2);
                    hashMap.put(string, column2);
                }
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw DbException.get(42102, exception, this.originalTable + "(" + exception.toString() + ")");
        }
        finally {
            JdbcUtils.closeSilently((Statement)object);
        }
        columnArray = new Column[arrayList.size()];
        arrayList.toArray(columnArray);
        this.setColumns(columnArray);
        int n7 = this.getId();
        this.linkedIndex = new LinkedIndex(this, n7, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.originalSchema, this.originalTable);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        String string5 = "";
        if (resultSet != null && resultSet.next()) {
            ArrayList<Column> arrayList2 = New.arrayList();
            do {
                int n8 = resultSet.getInt("KEY_SEQ");
                if (string5 == null) {
                    string5 = resultSet.getString("PK_NAME");
                }
                while (arrayList2.size() < n8) {
                    arrayList2.add(null);
                }
                String string6 = resultSet.getString("COLUMN_NAME");
                string6 = this.convertColumnName(string6);
                Column column3 = (Column)hashMap.get(string6);
                if (n8 == 0) {
                    arrayList2.add(column3);
                    continue;
                }
                arrayList2.set(n8 - 1, column3);
            } while (resultSet.next());
            this.addIndex(arrayList2, IndexType.createPrimaryKey(false, false));
            resultSet.close();
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        String string7 = null;
        ArrayList<Column> arrayList3 = New.arrayList();
        IndexType indexType = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                String string8;
                if (resultSet.getShort("TYPE") == 0 || string5.equals(string8 = resultSet.getString("INDEX_NAME"))) continue;
                if (string7 != null && !string7.equals(string8)) {
                    this.addIndex(arrayList3, indexType);
                    string7 = null;
                }
                if (string7 == null) {
                    string7 = string8;
                    arrayList3.clear();
                }
                n = !resultSet.getBoolean("NON_UNIQUE") ? 1 : 0;
                indexType = n != 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
                String string9 = resultSet.getString("COLUMN_NAME");
                string9 = this.convertColumnName(string9);
                column = (Column)hashMap.get(string9);
                arrayList3.add(column);
            }
            resultSet.close();
        }
        if (string7 != null) {
            this.addIndex(arrayList3, indexType);
        }
    }

    private static long convertPrecision(int n, long l) {
        switch (n) {
            case 2: 
            case 3: {
                if (l != 0L) break;
                l = 65535L;
                break;
            }
            case 91: {
                l = Math.max(8L, l);
                break;
            }
            case 93: {
                l = Math.max(23L, l);
                break;
            }
            case 92: {
                l = Math.max(6L, l);
            }
        }
        return l;
    }

    private static int convertScale(int n, int n2) {
        switch (n) {
            case 2: 
            case 3: {
                if (n2 >= 0) break;
                n2 = Short.MAX_VALUE;
            }
        }
        return n2;
    }

    private String convertColumnName(String string) {
        if ((this.storesMixedCase || this.storesLowerCase) && string.equals(StringUtils.toLowerEnglish(string))) {
            string = StringUtils.toUpperEnglish(string);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            string = StringUtils.toUpperEnglish(string);
        } else if (this.storesMixedCase && this.storesMixedCaseQuoted) {
            string = StringUtils.toUpperEnglish(string);
        }
        return string;
    }

    private void addIndex(List<Column> list, IndexType indexType) {
        int n = list.indexOf(null);
        if (n == 0) {
            this.trace.info("Omitting linked index - no recognized columns.");
            return;
        }
        if (n > 0) {
            this.trace.info("Unrecognized columns in linked index. Registering the index against the leading {0} recognized columns of {1} total columns.", n, list.size());
            list = list.subList(0, n);
        }
        Column[] columnArray = new Column[list.size()];
        list.toArray(columnArray);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap(columnArray), indexType);
        this.indexes.add(linkedIndex);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                stringBuilder.append("GLOBAL ");
            } else {
                stringBuilder.append("LOCAL ");
            }
            stringBuilder.append("TEMPORARY ");
        }
        stringBuilder.append("LINKED TABLE ").append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(StringUtils.quoteStringSQL(this.driver)).append(", ").append(StringUtils.quoteStringSQL(this.url)).append(", ").append(StringUtils.quoteStringSQL(this.user)).append(", ").append(StringUtils.quoteStringSQL(this.password)).append(", ").append(StringUtils.quoteStringSQL(this.originalTable)).append(')');
        if (this.emitUpdates) {
            stringBuilder.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            stringBuilder.append(" READONLY");
        }
        stringBuilder.append(" /*--hide--*/");
        return stringBuilder.toString();
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        if (this.conn != null) {
            try {
                this.conn.close(false);
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(Session session) {
        String string = "SELECT COUNT(*) FROM " + this.qualifiedTableName;
        try {
            PreparedStatement preparedStatement = this.execute(string, null, false);
            ResultSet resultSet = preparedStatement.getResultSet();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            this.reusePreparedStatement(preparedStatement, string);
            return l;
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string, exception);
        }
    }

    public static DbException wrapException(String string, Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        return DbException.get(90111, sQLException, string, sQLException.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement execute(String string, ArrayList<Value> arrayList, boolean bl) {
        if (this.conn == null) {
            throw this.connectException;
        }
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    int n2;
                    PreparedStatement preparedStatement = this.preparedMap.remove(string);
                    if (preparedStatement == null) {
                        preparedStatement = this.conn.getConnection().prepareStatement(string);
                    }
                    if (this.trace.isDebugEnabled()) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        statementBuilder.append(this.getName()).append(":\n").append(string);
                        if (arrayList != null && arrayList.size() > 0) {
                            statementBuilder.append(" {");
                            n2 = 1;
                            for (Value value : arrayList) {
                                statementBuilder.appendExceptFirst(", ");
                                statementBuilder.append(n2++).append(": ").append(value.getSQL());
                            }
                            statementBuilder.append('}');
                        }
                        statementBuilder.append(';');
                        this.trace.debug(statementBuilder.toString());
                    }
                    if (arrayList != null) {
                        n2 = arrayList.size();
                        for (int i = 0; i < n2; ++i) {
                            Value value = arrayList.get(i);
                            value.set(preparedStatement, i + 1);
                        }
                    }
                    preparedStatement.execute();
                    if (bl) {
                        this.reusePreparedStatement(preparedStatement, string);
                        return null;
                    }
                    return preparedStatement;
                }
            }
            catch (SQLException sQLException) {
                if (n >= 2) {
                    throw DbException.convert(sQLException);
                }
                this.conn.close(true);
                this.connect();
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE LINK";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.preparedMap = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        boolean bl;
        this.checkReadOnly();
        if (this.emitUpdates) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCanceled();
                Row row = rowList.next();
                Row row2 = rowList.next();
                this.linkedIndex.update(row, row2);
                session.log(this, (short)1, row);
                session.log(this, (short)0, row2);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public long getRowCountApproximation() {
        return 100000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reusePreparedStatement(PreparedStatement preparedStatement, String string) {
        TableLinkConnection tableLinkConnection = this.conn;
        synchronized (tableLinkConnection) {
            this.preparedMap.put(string, preparedStatement);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            Value value;
            Value value2 = row.getValue(i);
            if (value2 == null || (value = (column = this.columns[i]).validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i, value);
        }
    }

    @Override
    public Value getDefaultValue(Session session, Column column) {
        return null;
    }
}

