/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Other;

import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.DictionaryBasedSegment;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.common.Term;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DoubleArrayTrieSegment
extends DictionaryBasedSegment {
    @Override
    protected List<Term> segSentence(char[] sentence) {
        int i;
        char[] charArray = sentence;
        final int[] wordNet = new int[charArray.length];
        Arrays.fill(wordNet, 1);
        final Nature[] natureArray = this.config.speechTagging ? new Nature[charArray.length] : null;
        DoubleArrayTrie.Searcher searcher = CoreDictionary.trie.getSearcher(sentence, 0);
        while (searcher.next()) {
            int length = searcher.length;
            if (length <= wordNet[searcher.begin]) continue;
            wordNet[searcher.begin] = length;
            if (!this.config.speechTagging) continue;
            natureArray[searcher.begin] = ((CoreDictionary.Attribute)searcher.value).nature[0];
        }
        if (this.config.useCustomDictionary) {
            CustomDictionary.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

                @Override
                public void hit(int begin, int end, CoreDictionary.Attribute value) {
                    int length = end - begin;
                    if (length > wordNet[begin]) {
                        wordNet[begin] = length;
                        if (((DoubleArrayTrieSegment)DoubleArrayTrieSegment.this).config.speechTagging) {
                            natureArray[begin] = value.nature[0];
                        }
                    }
                }
            });
        }
        LinkedList<Term> termList = new LinkedList<Term>();
        if (this.config.speechTagging) {
            i = 0;
            while (i < natureArray.length) {
                if (natureArray[i] == null) {
                    int j;
                    for (j = i + 1; j < natureArray.length && natureArray[j] == null; ++j) {
                    }
                    List<AtomNode> atomNodeList = DoubleArrayTrieSegment.quickAtomSegment(charArray, i, j);
                    for (AtomNode atomNode : atomNodeList) {
                        if (atomNode.sWord.length() < wordNet[i]) continue;
                        wordNet[i] = atomNode.sWord.length();
                        natureArray[i] = atomNode.getNature();
                        i += wordNet[i];
                    }
                    i = j;
                    continue;
                }
                ++i;
            }
        }
        for (i = 0; i < wordNet.length; i += wordNet[i]) {
            Term term = new Term(new String(charArray, i, wordNet[i]), this.config.speechTagging ? (natureArray[i] == null ? Nature.nz : natureArray[i]) : null);
            term.offset = i;
            termList.add(term);
        }
        return termList;
    }

    public DoubleArrayTrieSegment() {
        this.config.useCustomDictionary = false;
    }
}

