/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;

public class KeywordExtractor {
    Segment defaultSegment = StandardTokenizer.SEGMENT;

    public boolean shouldInclude(Term term) {
        if (term.nature == null) {
            return false;
        }
        String nature = term.nature.toString();
        char firstChar = nature.charAt(0);
        switch (firstChar) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'm': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 'u': 
            case 'w': 
            case 'y': 
            case 'z': {
                return false;
            }
        }
        return term.word.trim().length() > 1 && !CoreStopWordDictionary.contains(term.word);
    }

    public KeywordExtractor setSegment(Segment segment) {
        this.defaultSegment = segment;
        return this;
    }
}

