/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.nnparser.Alphabet;
import com.hankcs.hanlp.dependency.nnparser.Context;
import com.hankcs.hanlp.dependency.nnparser.Dependency;
import com.hankcs.hanlp.dependency.nnparser.Instance;
import com.hankcs.hanlp.dependency.nnparser.Matrix;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkClassifier;
import com.hankcs.hanlp.dependency.nnparser.State;
import com.hankcs.hanlp.dependency.nnparser.TransitionSystem;
import com.hankcs.hanlp.dependency.nnparser.action.Action;
import com.hankcs.hanlp.dependency.nnparser.action.ActionFactory;
import com.hankcs.hanlp.dependency.nnparser.util.math;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NeuralNetworkParser
implements ICacheAble {
    Matrix W1;
    Matrix W2;
    Matrix E;
    Matrix b1;
    Matrix saved;
    Alphabet forms_alphabet;
    Alphabet postags_alphabet;
    Alphabet deprels_alphabet;
    Alphabet cluster4_types_alphabet;
    Alphabet cluster6_types_alphabet;
    Alphabet cluster_types_alphabet;
    Map<Integer, Integer> precomputation_id_encoder;
    Map<Integer, Integer> form_to_cluster4;
    Map<Integer, Integer> form_to_cluster6;
    Map<Integer, Integer> form_to_cluster;
    NeuralNetworkClassifier classifier;
    TransitionSystem system;
    String root;
    int kNilForm;
    int kNilPostag;
    int kNilDeprel;
    int kNilDistance;
    int kNilValency;
    int kNilCluster4;
    int kNilCluster6;
    int kNilCluster;
    int kFormInFeaturespace;
    int kPostagInFeaturespace;
    int kDeprelInFeaturespace;
    int kDistanceInFeaturespace;
    int kValencyInFeaturespace;
    int kCluster4InFeaturespace;
    int kCluster6InFeaturespace;
    int kClusterInFeaturespace;
    int kFeatureSpaceEnd;
    int nr_feature_types;
    boolean use_distance;
    boolean use_valency;
    boolean use_cluster;
    static String model_header;

    public boolean load(String path) {
        String binPath = path + ".bin";
        if (this.load(ByteArrayStream.createByteArrayStream(binPath))) {
            return true;
        }
        if (!this.loadTxt(path)) {
            return false;
        }
        try {
            Predefine.logger.info("\u6b63\u5728\u7f13\u5b58" + binPath);
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(binPath));
            this.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u7f13\u5b58" + binPath + "\u5931\u8d25\uff1a\n" + TextUtility.exceptionToString(e));
        }
        return true;
    }

    public boolean loadTxt(String path) {
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(path);
        model_header = lineIterator.next();
        if (model_header == null) {
            return false;
        }
        this.root = lineIterator.next();
        this.use_distance = "1".equals(lineIterator.next());
        this.use_valency = "1".equals(lineIterator.next());
        this.use_cluster = "1".equals(lineIterator.next());
        this.W1 = NeuralNetworkParser.read_matrix(lineIterator);
        this.W2 = NeuralNetworkParser.read_matrix(lineIterator);
        this.E = NeuralNetworkParser.read_matrix(lineIterator);
        this.b1 = NeuralNetworkParser.read_vector(lineIterator);
        this.saved = NeuralNetworkParser.read_matrix(lineIterator);
        this.forms_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
        this.postags_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
        this.deprels_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
        this.precomputation_id_encoder = NeuralNetworkParser.read_map(lineIterator);
        if (this.use_cluster) {
            this.cluster4_types_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
            this.cluster6_types_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
            this.cluster_types_alphabet = NeuralNetworkParser.read_alphabet(lineIterator);
            this.form_to_cluster4 = NeuralNetworkParser.read_map(lineIterator);
            this.form_to_cluster6 = NeuralNetworkParser.read_map(lineIterator);
            this.form_to_cluster = NeuralNetworkParser.read_map(lineIterator);
        }
        assert (!lineIterator.hasNext()) : "\u6587\u4ef6\u6709\u6b8b\u7559\uff0c\u53ef\u80fd\u662f\u8bfb\u53d6\u903b\u8f91\u4e0d\u5bf9";
        this.classifier = new NeuralNetworkClassifier(this.W1, this.W2, this.E, this.b1, this.saved, this.precomputation_id_encoder);
        this.classifier.canonical();
        return true;
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        TextUtility.writeString(model_header, out);
        TextUtility.writeString(this.root, out);
        out.writeInt(this.use_distance ? 1 : 0);
        out.writeInt(this.use_valency ? 1 : 0);
        out.writeInt(this.use_cluster ? 1 : 0);
        this.W1.save(out);
        this.W2.save(out);
        this.E.save(out);
        this.b1.save(out);
        this.saved.save(out);
        this.forms_alphabet.save(out);
        this.postags_alphabet.save(out);
        this.deprels_alphabet.save(out);
        NeuralNetworkParser.save_map(this.precomputation_id_encoder, out);
        if (this.use_cluster) {
            this.cluster4_types_alphabet.save(out);
            this.cluster6_types_alphabet.save(out);
            this.cluster_types_alphabet.save(out);
            NeuralNetworkParser.save_map(this.form_to_cluster4, out);
            NeuralNetworkParser.save_map(this.form_to_cluster6, out);
            NeuralNetworkParser.save_map(this.form_to_cluster, out);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        if (byteArray == null) {
            return false;
        }
        model_header = byteArray.nextString();
        this.root = byteArray.nextString();
        this.use_distance = byteArray.nextInt() == 1;
        this.use_valency = byteArray.nextInt() == 1;
        this.use_cluster = byteArray.nextInt() == 1;
        this.W1 = new Matrix();
        this.W1.load(byteArray);
        this.W2 = new Matrix();
        this.W2.load(byteArray);
        this.E = new Matrix();
        this.E.load(byteArray);
        this.b1 = new Matrix();
        this.b1.load(byteArray);
        this.saved = new Matrix();
        this.saved.load(byteArray);
        this.forms_alphabet = new Alphabet();
        this.forms_alphabet.load(byteArray);
        this.postags_alphabet = new Alphabet();
        this.postags_alphabet.load(byteArray);
        this.deprels_alphabet = new Alphabet();
        this.deprels_alphabet.load(byteArray);
        this.precomputation_id_encoder = NeuralNetworkParser.read_map(byteArray);
        if (this.use_cluster) {
            this.cluster4_types_alphabet = new Alphabet();
            this.cluster4_types_alphabet.load(byteArray);
            this.cluster6_types_alphabet = new Alphabet();
            this.cluster6_types_alphabet.load(byteArray);
            this.cluster_types_alphabet = new Alphabet();
            this.cluster_types_alphabet.load(byteArray);
            this.form_to_cluster4 = NeuralNetworkParser.read_map(byteArray);
            this.form_to_cluster6 = NeuralNetworkParser.read_map(byteArray);
            this.form_to_cluster = NeuralNetworkParser.read_map(byteArray);
        }
        assert (!byteArray.hasMore()) : "\u6587\u4ef6\u6709\u6b8b\u7559\uff0c\u53ef\u80fd\u662f\u8bfb\u53d6\u903b\u8f91\u4e0d\u5bf9";
        this.classifier = new NeuralNetworkClassifier(this.W1, this.W2, this.E, this.b1, this.saved, this.precomputation_id_encoder);
        this.classifier.canonical();
        return true;
    }

    private static Matrix read_matrix(IOUtil.LineIterator lineIterator) {
        double[][] valueArray;
        String[] rc = lineIterator.next().split("\t");
        int rows = Integer.valueOf(rc[0]);
        int cols = Integer.valueOf(rc[1]);
        for (double[] valueRow : valueArray = new double[rows][cols]) {
            String[] args = lineIterator.next().split("\t");
            for (int i = 0; i < valueRow.length; ++i) {
                valueRow[i] = Double.valueOf(args[i]);
            }
        }
        return new Matrix(valueArray);
    }

    private static Matrix read_vector(IOUtil.LineIterator lineIterator) {
        int rows = Integer.valueOf(lineIterator.next());
        double[][] valueArray = new double[rows][1];
        String[] args = lineIterator.next().split("\t");
        for (int i = 0; i < rows; ++i) {
            valueArray[i][0] = Double.valueOf(args[i]);
        }
        return new Matrix(valueArray);
    }

    private static Alphabet read_alphabet(IOUtil.LineIterator lineIterator) {
        int size = Integer.valueOf(lineIterator.next());
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            String[] args = lineIterator.next().split("\t");
            map.put(args[0], Integer.valueOf(args[1]));
        }
        Alphabet trie = new Alphabet();
        trie.build(map);
        return trie;
    }

    private static Map<Integer, Integer> read_map(IOUtil.LineIterator lineIterator) {
        int size = Integer.valueOf(lineIterator.next());
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < size; ++i) {
            String[] args = lineIterator.next().split("\t");
            map.put(Integer.valueOf(args[0]), Integer.valueOf(args[1]));
        }
        return map;
    }

    private static Map<Integer, Integer> read_map(ByteArray byteArray) {
        int size = byteArray.nextInt();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < size; ++i) {
            map.put(byteArray.nextInt(), byteArray.nextInt());
        }
        return map;
    }

    private static void save_map(Map<Integer, Integer> map, DataOutputStream out) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    void setup_system() {
        this.system = new TransitionSystem();
        this.system.set_root_relation(this.deprels_alphabet.idOf(this.root));
        this.system.set_number_of_relations(this.deprels_alphabet.size() - 2);
    }

    void build_feature_space() {
        this.kFormInFeaturespace = 0;
        this.kNilForm = this.forms_alphabet.idOf("$nil");
        this.kPostagInFeaturespace = this.kFeatureSpaceEnd = this.forms_alphabet.size();
        this.kNilPostag = this.kFeatureSpaceEnd + this.postags_alphabet.idOf("$nil");
        this.kFeatureSpaceEnd += this.postags_alphabet.size();
        this.kDeprelInFeaturespace = this.kFeatureSpaceEnd;
        this.kNilDeprel = this.kFeatureSpaceEnd + this.deprels_alphabet.idOf("$nil");
        this.kFeatureSpaceEnd += this.deprels_alphabet.size();
        this.kDistanceInFeaturespace = this.kFeatureSpaceEnd;
        this.kNilDistance = this.kFeatureSpaceEnd + (this.use_distance ? 8 : 0);
        this.kFeatureSpaceEnd += this.use_distance ? 9 : 0;
        this.kValencyInFeaturespace = this.kFeatureSpaceEnd;
        this.kNilValency = this.kFeatureSpaceEnd + (this.use_valency ? 8 : 0);
        this.kFeatureSpaceEnd += this.use_valency ? 9 : 0;
        this.kCluster4InFeaturespace = this.kFeatureSpaceEnd;
        if (this.use_cluster) {
            this.kNilCluster4 = this.kFeatureSpaceEnd + this.cluster4_types_alphabet.idOf("$nil");
            this.kFeatureSpaceEnd += this.cluster4_types_alphabet.size();
        } else {
            this.kNilCluster4 = this.kFeatureSpaceEnd;
        }
        this.kCluster6InFeaturespace = this.kFeatureSpaceEnd;
        if (this.use_cluster) {
            this.kNilCluster6 = this.kFeatureSpaceEnd + this.cluster6_types_alphabet.idOf("$nil");
            this.kFeatureSpaceEnd += this.cluster6_types_alphabet.size();
        } else {
            this.kNilCluster6 = this.kFeatureSpaceEnd;
        }
        this.kClusterInFeaturespace = this.kFeatureSpaceEnd;
        if (this.use_cluster) {
            this.kNilCluster = this.kFeatureSpaceEnd + this.cluster_types_alphabet.idOf("$nil");
            this.kFeatureSpaceEnd += this.cluster_types_alphabet.size();
        } else {
            this.kNilCluster = this.kFeatureSpaceEnd;
        }
    }

    void transduce_instance_to_dependency(Instance data, Dependency dependency, boolean with_dependencies) {
        int L = data.forms.size();
        for (int i = 0; i < L; ++i) {
            Integer postag;
            Integer form = this.forms_alphabet.idOf(data.forms.get(i));
            if (form == null) {
                form = this.forms_alphabet.idOf("$unk");
            }
            if ((postag = this.postags_alphabet.idOf(data.postags.get(i))) == null) {
                postag = this.postags_alphabet.idOf("$unk");
            }
            int deprel = with_dependencies ? this.deprels_alphabet.idOf(data.deprels.get(i)) : -1;
            dependency.forms.add(form);
            dependency.postags.add(postag);
            dependency.heads.add(with_dependencies ? data.heads.get(i) : -1);
            dependency.deprels.add(with_dependencies ? deprel : -1);
        }
    }

    void get_cluster_from_dependency(Dependency data, List<Integer> cluster4, List<Integer> cluster6, List<Integer> cluster) {
        if (this.use_cluster) {
            int L = data.forms.size();
            for (int i = 0; i < L; ++i) {
                int form = data.forms.get(i);
                cluster4.add(i == 0 ? this.cluster4_types_alphabet.idOf("$root") : this.form_to_cluster4.get(form));
                cluster6.add(i == 0 ? this.cluster6_types_alphabet.idOf("$root") : this.form_to_cluster6.get(form));
                cluster.add(i == 0 ? this.cluster_types_alphabet.idOf("$root") : this.form_to_cluster.get(form));
            }
        }
    }

    void predict(Instance data, List<Integer> heads, List<String> deprels) {
        int i;
        Dependency dependency = new Dependency();
        ArrayList<Integer> cluster = new ArrayList<Integer>();
        ArrayList<Integer> cluster4 = new ArrayList<Integer>();
        ArrayList<Integer> cluster6 = new ArrayList<Integer>();
        this.transduce_instance_to_dependency(data, dependency, false);
        this.get_cluster_from_dependency(dependency, cluster4, cluster6, cluster);
        int L = data.forms.size();
        State[] states = new State[L * 2];
        for (i = 0; i < states.length; ++i) {
            states[i] = new State();
        }
        states[0].copy(new State(dependency));
        this.system.transit(states[0], ActionFactory.make_shift(), states[1]);
        for (int step = 1; step < L * 2 - 1; ++step) {
            ArrayList<Integer> attributes = new ArrayList<Integer>();
            if (this.use_cluster) {
                this.get_features(states[step], cluster4, cluster6, cluster, attributes);
            } else {
                this.get_features(states[step], attributes);
            }
            ArrayList<Double> scores = new ArrayList<Double>(this.system.number_of_transitions());
            this.classifier.score(attributes, scores);
            ArrayList<Action> possible_actions = new ArrayList<Action>();
            this.system.get_possible_actions(states[step], possible_actions);
            int best = -1;
            for (int j = 0; j < possible_actions.size(); ++j) {
                int l = this.system.transform((Action)possible_actions.get(j));
                if (best != -1 && !((Double)scores.get(best) < (Double)scores.get(l))) continue;
                best = l;
            }
            Action act = this.system.transform(best);
            this.system.transit(states[step], act, states[step + 1]);
        }
        for (i = 0; i < L; ++i) {
            heads.add(states[L * 2 - 1].heads.get(i));
            deprels.add(this.deprels_alphabet.labelOf(states[L * 2 - 1].deprels.get(i)));
        }
    }

    void get_context(State s, Context ctx) {
        ctx.S0 = s.stack.size() > 0 ? s.stack.get(s.stack.size() - 1) : -1;
        ctx.S1 = s.stack.size() > 1 ? s.stack.get(s.stack.size() - 2) : -1;
        ctx.S2 = s.stack.size() > 2 ? s.stack.get(s.stack.size() - 3) : -1;
        ctx.N0 = s.buffer < s.ref.size() ? s.buffer : -1;
        ctx.N1 = s.buffer + 1 < s.ref.size() ? s.buffer + 1 : -1;
        ctx.N2 = s.buffer + 2 < s.ref.size() ? s.buffer + 2 : -1;
        ctx.S0L = ctx.S0 >= 0 ? s.left_most_child.get(ctx.S0) : -1;
        ctx.S0R = ctx.S0 >= 0 ? s.right_most_child.get(ctx.S0) : -1;
        ctx.S0L2 = ctx.S0 >= 0 ? s.left_2nd_most_child.get(ctx.S0) : -1;
        ctx.S0R2 = ctx.S0 >= 0 ? s.right_2nd_most_child.get(ctx.S0) : -1;
        ctx.S0LL = ctx.S0L >= 0 ? s.left_most_child.get(ctx.S0L) : -1;
        ctx.S0RR = ctx.S0R >= 0 ? s.right_most_child.get(ctx.S0R) : -1;
        ctx.S1L = ctx.S1 >= 0 ? s.left_most_child.get(ctx.S1) : -1;
        ctx.S1R = ctx.S1 >= 0 ? s.right_most_child.get(ctx.S1) : -1;
        ctx.S1L2 = ctx.S1 >= 0 ? s.left_2nd_most_child.get(ctx.S1) : -1;
        ctx.S1R2 = ctx.S1 >= 0 ? s.right_2nd_most_child.get(ctx.S1) : -1;
        ctx.S1LL = ctx.S1L >= 0 ? s.left_most_child.get(ctx.S1L) : -1;
        ctx.S1RR = ctx.S1R >= 0 ? s.right_most_child.get(ctx.S1R) : -1;
    }

    void get_features(State s, List<Integer> features) {
        Context ctx = new Context();
        this.get_context(s, ctx);
        this.get_basic_features(ctx, s.ref.forms, s.ref.postags, s.deprels, features);
        this.get_distance_features(ctx, features);
        this.get_valency_features(ctx, s.nr_left_children, s.nr_right_children, features);
    }

    void get_features(State s, List<Integer> cluster4, List<Integer> cluster6, List<Integer> cluster, List<Integer> features) {
        Context ctx = new Context();
        this.get_context(s, ctx);
        this.get_basic_features(ctx, s.ref.forms, s.ref.postags, s.deprels, features);
        this.get_distance_features(ctx, features);
        this.get_valency_features(ctx, s.nr_left_children, s.nr_right_children, features);
        this.get_cluster_features(ctx, cluster4, cluster6, cluster, features);
    }

    int FORM(List<Integer> forms, int id) {
        return id != -1 ? forms.get(id) : this.kNilForm;
    }

    int POSTAG(List<Integer> postags, int id) {
        return id != -1 ? postags.get(id) + this.kPostagInFeaturespace : this.kNilPostag;
    }

    int DEPREL(List<Integer> deprels, int id) {
        return id != -1 ? deprels.get(id) + this.kDeprelInFeaturespace : this.kNilDeprel;
    }

    void PUSH(List<Integer> features, int feat) {
        features.add(feat);
    }

    void get_basic_features(Context ctx, List<Integer> forms, List<Integer> postags, List<Integer> deprels, List<Integer> features) {
        this.PUSH(features, this.FORM(forms, ctx.S0));
        this.PUSH(features, this.POSTAG(postags, ctx.S0));
        this.PUSH(features, this.FORM(forms, ctx.S1));
        this.PUSH(features, this.POSTAG(postags, ctx.S1));
        this.PUSH(features, this.FORM(forms, ctx.S2));
        this.PUSH(features, this.POSTAG(postags, ctx.S2));
        this.PUSH(features, this.FORM(forms, ctx.N0));
        this.PUSH(features, this.POSTAG(postags, ctx.N0));
        this.PUSH(features, this.FORM(forms, ctx.N1));
        this.PUSH(features, this.POSTAG(postags, ctx.N1));
        this.PUSH(features, this.FORM(forms, ctx.N2));
        this.PUSH(features, this.POSTAG(postags, ctx.N2));
        this.PUSH(features, this.FORM(forms, ctx.S0L));
        this.PUSH(features, this.POSTAG(postags, ctx.S0L));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0L));
        this.PUSH(features, this.FORM(forms, ctx.S0R));
        this.PUSH(features, this.POSTAG(postags, ctx.S0R));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0R));
        this.PUSH(features, this.FORM(forms, ctx.S0L2));
        this.PUSH(features, this.POSTAG(postags, ctx.S0L2));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0L2));
        this.PUSH(features, this.FORM(forms, ctx.S0R2));
        this.PUSH(features, this.POSTAG(postags, ctx.S0R2));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0R2));
        this.PUSH(features, this.FORM(forms, ctx.S0LL));
        this.PUSH(features, this.POSTAG(postags, ctx.S0LL));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0LL));
        this.PUSH(features, this.FORM(forms, ctx.S0RR));
        this.PUSH(features, this.POSTAG(postags, ctx.S0RR));
        this.PUSH(features, this.DEPREL(deprels, ctx.S0RR));
        this.PUSH(features, this.FORM(forms, ctx.S1L));
        this.PUSH(features, this.POSTAG(postags, ctx.S1L));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1L));
        this.PUSH(features, this.FORM(forms, ctx.S1R));
        this.PUSH(features, this.POSTAG(postags, ctx.S1R));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1R));
        this.PUSH(features, this.FORM(forms, ctx.S1L2));
        this.PUSH(features, this.POSTAG(postags, ctx.S1L2));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1L2));
        this.PUSH(features, this.FORM(forms, ctx.S1R2));
        this.PUSH(features, this.POSTAG(postags, ctx.S1R2));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1R2));
        this.PUSH(features, this.FORM(forms, ctx.S1LL));
        this.PUSH(features, this.POSTAG(postags, ctx.S1LL));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1LL));
        this.PUSH(features, this.FORM(forms, ctx.S1RR));
        this.PUSH(features, this.POSTAG(postags, ctx.S1RR));
        this.PUSH(features, this.DEPREL(deprels, ctx.S1RR));
    }

    void get_distance_features(Context ctx, List<Integer> features) {
        if (!this.use_distance) {
            return;
        }
        int dist = 8;
        if (ctx.S0 >= 0 && ctx.S1 >= 0 && (dist = math.binned_1_2_3_4_5_6_10[ctx.S0 - ctx.S1]) == 10) {
            dist = 7;
        }
        features.add(dist + this.kDistanceInFeaturespace);
    }

    void get_valency_features(Context ctx, List<Integer> nr_left_children, List<Integer> nr_right_children, List<Integer> features) {
        if (!this.use_valency) {
            return;
        }
        int lvc = 8;
        int rvc = 8;
        if (ctx.S0 >= 0) {
            lvc = math.binned_1_2_3_4_5_6_10[nr_left_children.get(ctx.S0)];
            rvc = math.binned_1_2_3_4_5_6_10[nr_right_children.get(ctx.S0)];
            if (lvc == 10) {
                lvc = 7;
            }
            if (rvc == 10) {
                rvc = 7;
            }
        }
        features.add(lvc + this.kValencyInFeaturespace);
        features.add(rvc + this.kValencyInFeaturespace);
        lvc = 8;
        rvc = 8;
        if (ctx.S1 >= 0) {
            lvc = math.binned_1_2_3_4_5_6_10[nr_left_children.get(ctx.S1)];
            rvc = math.binned_1_2_3_4_5_6_10[nr_right_children.get(ctx.S1)];
            if (lvc == 10) {
                lvc = 7;
            }
            if (rvc == 10) {
                rvc = 7;
            }
        }
        features.add(lvc + this.kValencyInFeaturespace);
        features.add(rvc + this.kValencyInFeaturespace);
    }

    int CLUSTER(List<Integer> cluster, int id) {
        return id >= 0 ? cluster.get(id) + this.kClusterInFeaturespace : this.kNilCluster;
    }

    int CLUSTER4(List<Integer> cluster4, int id) {
        return id >= 0 ? cluster4.get(id) + this.kCluster4InFeaturespace : this.kNilCluster4;
    }

    int CLUSTER6(List<Integer> cluster6, int id) {
        return id >= 0 ? cluster6.get(id) + this.kCluster6InFeaturespace : this.kNilCluster6;
    }

    void get_cluster_features(Context ctx, List<Integer> cluster4, List<Integer> cluster6, List<Integer> cluster, List<Integer> features) {
        if (!this.use_cluster) {
            return;
        }
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0));
        this.PUSH(features, this.CLUSTER4(cluster4, ctx.S0));
        this.PUSH(features, this.CLUSTER6(cluster6, ctx.S0));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.N0));
        this.PUSH(features, this.CLUSTER4(cluster4, ctx.N0));
        this.PUSH(features, this.CLUSTER6(cluster6, ctx.N0));
        this.PUSH(features, this.CLUSTER(cluster, ctx.N1));
        this.PUSH(features, this.CLUSTER(cluster, ctx.N2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0L));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0R));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0L2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0R2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0LL));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S0RR));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1L));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1R));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1L2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1R2));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1LL));
        this.PUSH(features, this.CLUSTER(cluster, ctx.S1RR));
    }
}

