/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TfIdf {
    public static <TERM> Map<TERM, Double> tf(Collection<TERM> document, TfType type) {
        HashMap<TERM, Double> tf = new HashMap<TERM, Double>();
        for (Object term : document) {
            Double f = (Double)tf.get(term);
            if (f == null) {
                f = 0.0;
            }
            tf.put(term, f + 1.0);
        }
        if (type != TfType.NATURAL) {
            for (Object term : tf.keySet()) {
                switch (type) {
                    case LOGARITHM: {
                        tf.put(term, 1.0 + Math.log((Double)tf.get(term)));
                        break;
                    }
                    case BOOLEAN: {
                        tf.put(term, (Double)tf.get(term) == 0.0 ? 0.0 : 1.0);
                    }
                }
            }
        }
        return tf;
    }

    public static <TERM> Map<TERM, Double> tf(Collection<TERM> document) {
        return TfIdf.tf(document, TfType.NATURAL);
    }

    public static <TERM> Iterable<Map<TERM, Double>> tfs(Iterable<Collection<TERM>> documents, TfType type) {
        ArrayList<Map<TERM, Double>> tfs = new ArrayList<Map<TERM, Double>>();
        for (Collection<TERM> document : documents) {
            tfs.add(TfIdf.tf(document, type));
        }
        return tfs;
    }

    public static <TERM> Iterable<Map<TERM, Double>> tfs(Iterable<Collection<TERM>> documents) {
        return TfIdf.tfs(documents, TfType.NATURAL);
    }

    public static <TERM> Map<TERM, Double> idf(Iterable<Iterable<TERM>> documentVocabularies, boolean smooth, boolean addOne) {
        HashMap<TERM, Integer> df = new HashMap<TERM, Integer>();
        int d = smooth ? 1 : 0;
        boolean a = addOne;
        int n = d;
        for (Iterable<TERM> documentVocabulary : documentVocabularies) {
            ++n;
            for (Object term : documentVocabulary) {
                Integer t = (Integer)df.get(term);
                if (t == null) {
                    t = d;
                }
                df.put(term, t + 1);
            }
        }
        HashMap<TERM, Double> idf = new HashMap<TERM, Double>();
        for (Map.Entry e : df.entrySet()) {
            Object term;
            term = e.getKey();
            double f = ((Integer)e.getValue()).intValue();
            idf.put(term, Math.log((double)n / f) + (double)a);
        }
        return idf;
    }

    public static <TERM> Map<TERM, Double> idf(Iterable<Iterable<TERM>> documentVocabularies) {
        return TfIdf.idf(documentVocabularies, true, true);
    }

    public static <TERM> Map<TERM, Double> tfIdf(Map<TERM, Double> tf, Map<TERM, Double> idf, Normalization normalization) {
        HashMap<Object, Double> tfIdf = new HashMap<Object, Double>();
        for (TERM term : tf.keySet()) {
            Double IDF;
            Double TF = tf.get(term);
            if (TF == null) {
                TF = 1.0;
            }
            if ((IDF = idf.get(term)) == null) {
                IDF = 1.0;
            }
            tfIdf.put(term, TF * IDF);
        }
        if (normalization == Normalization.COSINE) {
            double n = 0.0;
            Iterator<Object> iterator = tfIdf.values().iterator();
            while (iterator.hasNext()) {
                double x = (Double)iterator.next();
                n += x * x;
            }
            n = Math.sqrt(n);
            for (Object term : tfIdf.keySet()) {
                tfIdf.put(term, (Double)tfIdf.get(term) / n);
            }
        }
        return tfIdf;
    }

    public static <TERM> Map<TERM, Double> tfIdf(Map<TERM, Double> tf, Map<TERM, Double> idf) {
        return TfIdf.tfIdf(tf, idf, Normalization.NONE);
    }

    public static <TERM> Map<TERM, Double> idfFromTfs(Iterable<Map<TERM, Double>> tfs, boolean smooth, boolean addOne) {
        return TfIdf.idf(new KeySetIterable(tfs), smooth, addOne);
    }

    public static <TERM> Map<TERM, Double> idfFromTfs(Iterable<Map<TERM, Double>> tfs) {
        return TfIdf.idfFromTfs(tfs, true, true);
    }

    private static class KeySetIterable<KEY, VALUE>
    implements Iterable<Iterable<KEY>> {
        private final Iterator<Map<KEY, VALUE>> maps;

        public KeySetIterable(Iterable<Map<KEY, VALUE>> maps) {
            this.maps = maps.iterator();
        }

        @Override
        public Iterator<Iterable<KEY>> iterator() {
            return new Iterator<Iterable<KEY>>(){

                @Override
                public boolean hasNext() {
                    return KeySetIterable.this.maps.hasNext();
                }

                @Override
                public Iterable<KEY> next() {
                    return ((Map)KeySetIterable.this.maps.next()).keySet();
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    public static enum Normalization {
        NONE,
        COSINE;

    }

    public static enum TfType {
        NATURAL,
        LOGARITHM,
        BOOLEAN;

    }
}

