/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.FeatureTemplate;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CRFModel
implements ICacheAble {
    Map<String, Integer> tag2id;
    protected String[] id2tag;
    ITrie<FeatureFunction> featureFunctionTrie;
    List<FeatureTemplate> featureTemplateList;
    protected double[][] matrix;

    public CRFModel() {
        this.featureFunctionTrie = new DoubleArrayTrie<FeatureFunction>();
    }

    public CRFModel(ITrie<FeatureFunction> featureFunctionTrie) {
        this.featureFunctionTrie = featureFunctionTrie;
    }

    protected void onLoadTxtFinished() {
    }

    public static CRFModel loadTxt(String path, CRFModel instance) {
        Object args;
        String line;
        CRFModel CRFModel2 = instance;
        if (CRFModel2.load(ByteArray.createByteArray(path + ".bin"))) {
            return CRFModel2;
        }
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(path);
        if (!lineIterator.hasNext()) {
            return null;
        }
        Predefine.logger.info(lineIterator.next());
        Predefine.logger.info(lineIterator.next());
        int maxid = Integer.parseInt(lineIterator.next().substring("maxid:".length()).trim());
        Predefine.logger.info(lineIterator.next());
        lineIterator.next();
        int id = 0;
        CRFModel2.tag2id = new HashMap<String, Integer>();
        while ((line = lineIterator.next()).length() != 0) {
            CRFModel2.tag2id.put(line, id);
            ++id;
        }
        CRFModel2.id2tag = new String[CRFModel2.tag2id.size()];
        int size = CRFModel2.id2tag.length;
        for (Map.Entry<String, Integer> entry : CRFModel2.tag2id.entrySet()) {
            CRFModel2.id2tag[entry.getValue().intValue()] = entry.getKey();
        }
        TreeMap<Object, FeatureFunction> featureFunctionMap = new TreeMap<Object, FeatureFunction>();
        TreeMap<Integer, FeatureFunction> featureFunctionList = new TreeMap<Integer, FeatureFunction>();
        CRFModel2.featureTemplateList = new LinkedList<FeatureTemplate>();
        while ((line = lineIterator.next()).length() != 0) {
            if (!"B".equals(line)) {
                FeatureTemplate featureTemplate = FeatureTemplate.create(line);
                CRFModel2.featureTemplateList.add(featureTemplate);
                continue;
            }
            CRFModel2.matrix = new double[size][size];
        }
        int b = -1;
        if (CRFModel2.matrix != null) {
            args = lineIterator.next().split(" ", 2);
            b = Integer.valueOf(args[0]);
            featureFunctionList.put(b, null);
        }
        while ((line = lineIterator.next()).length() != 0) {
            args = line.split(" ", 2);
            char[] cArray = ((String)args[1]).toCharArray();
            FeatureFunction featureFunction = new FeatureFunction(cArray, size);
            featureFunctionMap.put(args[1], featureFunction);
            featureFunctionList.put(Integer.parseInt((String)args[0]), featureFunction);
        }
        for (Map.Entry entry : featureFunctionList.entrySet()) {
            int i;
            int fid = (Integer)entry.getKey();
            FeatureFunction featureFunction = (FeatureFunction)entry.getValue();
            if (fid == b) {
                for (i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        CRFModel2.matrix[i][j] = Double.parseDouble(lineIterator.next());
                    }
                }
                continue;
            }
            for (i = 0; i < size; ++i) {
                featureFunction.w[i] = Double.parseDouble(lineIterator.next());
            }
        }
        if (lineIterator.hasNext()) {
            Predefine.logger.warning("\u6587\u672c\u8bfb\u53d6\u6709\u6b8b\u7559\uff0c\u53ef\u80fd\u4f1a\u51fa\u95ee\u9898\uff01" + path);
        }
        lineIterator.close();
        Predefine.logger.info("\u5f00\u59cb\u6784\u5efatrie\u6811");
        CRFModel2.featureFunctionTrie.build(featureFunctionMap);
        try {
            Predefine.logger.info("\u5f00\u59cb\u7f13\u5b58" + path + ".bin");
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path + ".bin"));
            CRFModel2.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u7f13\u5b58" + path + ".bin" + "\u65f6\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
        }
        CRFModel2.onLoadTxtFinished();
        return CRFModel2;
    }

    public void tag(Table table) {
        int size = table.size();
        if (size == 0) {
            return;
        }
        int tagSize = this.id2tag.length;
        double[][] net = new double[size][tagSize];
        for (int i = 0; i < size; ++i) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            for (int tag = 0; tag < tagSize; ++tag) {
                net[i][tag] = CRFModel.computeScore(scoreList, tag);
            }
        }
        if (size == 1) {
            double maxScore = -1.0E10;
            int bestTag = 0;
            for (int tag = 0; tag < net[0].length; ++tag) {
                if (!(net[0][tag] > maxScore)) continue;
                maxScore = net[0][tag];
                bestTag = tag;
            }
            table.setLast(0, this.id2tag[bestTag]);
            return;
        }
        int[][] from = new int[size][tagSize];
        double[][] maxScoreAt = new double[2][tagSize];
        System.arraycopy(net[0], 0, maxScoreAt[0], 0, tagSize);
        int curI = 0;
        for (int i = 1; i < size; ++i) {
            curI = i & 1;
            int preI = 1 - curI;
            for (int now = 0; now < tagSize; ++now) {
                double maxScore = -1.0E10;
                for (int pre = 0; pre < tagSize; ++pre) {
                    double score = maxScoreAt[preI][pre] + this.matrix[pre][now] + net[i][now];
                    if (!(score > maxScore)) continue;
                    maxScore = score;
                    from[i][now] = pre;
                    maxScoreAt[curI][now] = maxScore;
                }
                net[i][now] = maxScore;
            }
        }
        double maxScore = -1.0E10;
        int maxTag = 0;
        for (int tag = 0; tag < tagSize; ++tag) {
            if (!(maxScoreAt[curI][tag] > maxScore)) continue;
            maxScore = maxScoreAt[curI][tag];
            maxTag = tag;
        }
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        for (int i = size - 2; i > 0; --i) {
            table.setLast(i, this.id2tag[maxTag]);
            maxTag = from[i][maxTag];
        }
        table.setLast(0, this.id2tag[maxTag]);
    }

    protected LinkedList<double[]> computeScoreList(Table table, int current) {
        LinkedList<double[]> scoreList = new LinkedList<double[]>();
        for (FeatureTemplate featureTemplate : this.featureTemplateList) {
            char[] o = featureTemplate.generateParameter(table, current);
            FeatureFunction featureFunction = this.featureFunctionTrie.get(o);
            if (featureFunction == null) continue;
            scoreList.add(featureFunction.w);
        }
        return scoreList;
    }

    protected static double computeScore(LinkedList<double[]> scoreList, int tag) {
        double score = 0.0;
        for (double[] w : scoreList) {
            score += w[tag];
        }
        return score;
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.id2tag.length);
        for (String tag : this.id2tag) {
            out.writeUTF(tag);
        }
        FeatureFunction[] valueArray = this.featureFunctionTrie.getValueArray((FeatureFunction[])new FeatureFunction[0]);
        out.writeInt(valueArray.length);
        for (FeatureFunction featureFunction : valueArray) {
            featureFunction.save(out);
        }
        this.featureFunctionTrie.save(out);
        out.writeInt(this.featureTemplateList.size());
        for (FeatureTemplate featureTemplate : this.featureTemplateList) {
            featureTemplate.save(out);
        }
        if (this.matrix != null) {
            out.writeInt(this.matrix.length);
            double[][] dArray = this.matrix;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] line;
                for (double v : line = dArray[i]) {
                    out.writeDouble(v);
                }
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        if (byteArray == null) {
            return false;
        }
        try {
            int i;
            int size = byteArray.nextInt();
            this.id2tag = new String[size];
            this.tag2id = new HashMap<String, Integer>(size);
            for (int i2 = 0; i2 < this.id2tag.length; ++i2) {
                this.id2tag[i2] = byteArray.nextUTF();
                this.tag2id.put(this.id2tag[i2], i2);
            }
            FeatureFunction[] valueArray = new FeatureFunction[byteArray.nextInt()];
            for (i = 0; i < valueArray.length; ++i) {
                valueArray[i] = new FeatureFunction();
                valueArray[i].load(byteArray);
            }
            this.featureFunctionTrie.load(byteArray, (FeatureFunction[])valueArray);
            size = byteArray.nextInt();
            this.featureTemplateList = new ArrayList<FeatureTemplate>(size);
            for (i = 0; i < size; ++i) {
                FeatureTemplate featureTemplate = new FeatureTemplate();
                featureTemplate.load(byteArray);
                this.featureTemplateList.add(featureTemplate);
            }
            size = byteArray.nextInt();
            if (size == 0) {
                return true;
            }
            this.matrix = new double[size][size];
            for (i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    this.matrix[i][j] = byteArray.nextDouble();
                }
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u7f13\u5b58\u8f7d\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u7248\u672c\u53d8\u8fc1\u5e26\u6765\u7684\u4e0d\u517c\u5bb9\u3002\u5177\u4f53\u5f02\u5e38\u662f\uff1a\n" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    public static CRFModel loadTxt(String path) {
        return CRFModel.loadTxt(path, new CRFModel(new DoubleArrayTrie<FeatureFunction>()));
    }

    public static CRFModel load(String path) {
        CRFModel model = CRFModel.loadBin(path + ".bin");
        if (model != null) {
            return model;
        }
        return CRFModel.loadTxt(path, new CRFModel(new DoubleArrayTrie<FeatureFunction>()));
    }

    public static CRFModel loadBin(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path);
        if (byteArray == null) {
            return null;
        }
        CRFModel model = new CRFModel();
        if (model.load(byteArray)) {
            return model;
        }
        return null;
    }

    public Integer getTagId(String tag) {
        return this.tag2id.get(tag);
    }

    public Map<String, Integer> getTag2id() {
        return this.tag2id;
    }
}

