/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.model.crf.crfpp.Path;
import java.util.ArrayList;
import java.util.List;

public class Node {
    public int x;
    public int y;
    public double alpha;
    public double beta;
    public double cost;
    public double bestCost;
    public Node prev;
    public List<Integer> fVector;
    public List<Path> lpath = new ArrayList<Path>();
    public List<Path> rpath = new ArrayList<Path>();
    public static double LOG2 = 0.69314718055;
    public static int MINUS_LOG_EPSILON = 50;

    public Node() {
        this.clear();
        this.bestCost = 0.0;
        this.prev = null;
    }

    public static double logsumexp(double x, double y, boolean flg) {
        if (flg) {
            return y;
        }
        double vmin = Math.min(x, y);
        double vmax = Math.max(x, y);
        if (vmax > vmin + (double)MINUS_LOG_EPSILON) {
            return vmax;
        }
        return vmax + Math.log(Math.exp(vmin - vmax) + 1.0);
    }

    public void calcAlpha() {
        this.alpha = 0.0;
        for (Path p : this.lpath) {
            this.alpha = Node.logsumexp(this.alpha, p.cost + p.lnode.alpha, p == this.lpath.get(0));
        }
        this.alpha += this.cost;
    }

    public void calcBeta() {
        this.beta = 0.0;
        for (Path p : this.rpath) {
            this.beta = Node.logsumexp(this.beta, p.cost + p.rnode.beta, p == this.rpath.get(0));
        }
        this.beta += this.cost;
    }

    public void calcExpectation(double[] expected, double Z, int size) {
        double c = Math.exp(this.alpha + this.beta - this.cost - Z);
        int i = 0;
        while (this.fVector.get(i) != -1) {
            int idx;
            int n = idx = this.fVector.get(i) + this.y;
            expected[n] = expected[n] + c;
            ++i;
        }
        for (Path p : this.lpath) {
            p.calcExpectation(expected, Z, size);
        }
    }

    public void clear() {
        this.y = 0;
        this.x = 0;
        this.cost = 0.0;
        this.beta = 0.0;
        this.alpha = 0.0;
        this.prev = null;
        this.fVector = null;
        this.lpath.clear();
        this.rpath.clear();
    }
}

