/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheFetchNearCacheInvalidationMetadataCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationMetaDataFetcher;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ClientCacheInvalidationMetaDataFetcher
extends InvalidationMetaDataFetcher {
    private final ClientClusterService clusterService;
    private final HazelcastClientInstanceImpl clientImpl;

    public ClientCacheInvalidationMetaDataFetcher(ClientContext clientContext) {
        super(clientContext.getLoggingService().getLogger(ClientCacheInvalidationMetaDataFetcher.class));
        this.clusterService = clientContext.getClusterService();
        this.clientImpl = (HazelcastClientInstanceImpl)clientContext.getHazelcastInstance();
    }

    protected Collection<Member> getDataMembers() {
        return this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
    }

    protected InternalCompletableFuture fetchMetadataOf(Address address, List<String> names) {
        ClientMessage message = CacheFetchNearCacheInvalidationMetadataCodec.encodeRequest(names, (Address)address);
        ClientInvocation invocation = new ClientInvocation(this.clientImpl, message, null, address);
        return invocation.invoke();
    }

    protected void extractMemberMetadata(Member member, InternalCompletableFuture future, InvalidationMetaDataFetcher.MetadataHolder metadataHolder) throws Exception {
        ClientMessage message = (ClientMessage)future.get(1L, TimeUnit.MINUTES);
        CacheFetchNearCacheInvalidationMetadataCodec.ResponseParameters response = CacheFetchNearCacheInvalidationMetadataCodec.decodeResponse((ClientMessage)message);
        metadataHolder.setMetadata((Collection)response.partitionUuidList, (Collection)response.namePartitionSequenceList);
    }
}

