/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapGetForUpdateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapSetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapValuesWithPredicateCodec;
import com.hazelcast.client.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientTxnMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMap<K, V> {
    public ClientTxnMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        ClientMessage request = TransactionalMapContainsKeyCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return TransactionalMapContainsKeyCodec.decodeResponse((ClientMessage)response).response;
    }

    public V get(Object key) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        ClientMessage request = TransactionalMapGetCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapGetCodec.decodeResponse((ClientMessage)response).response);
    }

    public V getForUpdate(Object key) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        ClientMessage request = TransactionalMapGetForUpdateCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapGetForUpdateCodec.decodeResponse((ClientMessage)response).response);
    }

    public int size() {
        ClientMessage request = TransactionalMapSizeCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalMapSizeCodec.decodeResponse((ClientMessage)response).response;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)"key can't be null");
        Preconditions.checkNotNull(value, (String)"value can't be null");
        ClientMessage request = TransactionalMapPutCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value), (long)timeunit.toMillis(ttl));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapPutCodec.decodeResponse((ClientMessage)response).response);
    }

    public void set(K key, V value) {
        Preconditions.checkNotNull(key, (String)"key can't be null");
        Preconditions.checkNotNull(value, (String)"value can't be null");
        ClientMessage request = TransactionalMapSetCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        this.invoke(request);
    }

    public V putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key, (String)"key can't be null");
        Preconditions.checkNotNull(value, (String)"value can't be null");
        ClientMessage request = TransactionalMapPutIfAbsentCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapPutIfAbsentCodec.decodeResponse((ClientMessage)response).response);
    }

    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, (String)"key can't be null");
        Preconditions.checkNotNull(value, (String)"value can't be null");
        ClientMessage request = TransactionalMapReplaceCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapReplaceCodec.decodeResponse((ClientMessage)response).response);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (String)"key can't be null");
        Preconditions.checkNotNull(oldValue, (String)"oldValue can't be null");
        Preconditions.checkNotNull(newValue, (String)"newValue can't be null");
        ClientMessage request = TransactionalMapReplaceIfSameCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(oldValue), (Data)this.toData(newValue));
        ClientMessage response = this.invoke(request);
        return TransactionalMapReplaceIfSameCodec.decodeResponse((ClientMessage)response).response;
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        ClientMessage request = TransactionalMapRemoveCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapRemoveCodec.decodeResponse((ClientMessage)response).response);
    }

    public void delete(Object key) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        ClientMessage request = TransactionalMapDeleteCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        this.invoke(request);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)"key can't be null");
        Preconditions.checkNotNull((Object)value, (String)"value can't be null");
        ClientMessage request = TransactionalMapRemoveIfSameCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return TransactionalMapRemoveIfSameCodec.decodeResponse((ClientMessage)response).response;
    }

    public Set<K> keySet() {
        ClientMessage request = TransactionalMapKeySetCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        List dataKeySet = TransactionalMapKeySetCodec.decodeResponse((ClientMessage)response).response;
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)"predicate can't null");
        ClientMessage request = TransactionalMapKeySetWithPredicateCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(predicate));
        ClientMessage response = this.invoke(request);
        List dataKeySet = TransactionalMapKeySetWithPredicateCodec.decodeResponse((ClientMessage)response).response;
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Collection<V> values() {
        ClientMessage request = TransactionalMapValuesCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        List dataValues = TransactionalMapValuesCodec.decodeResponse((ClientMessage)response).response;
        return new UnmodifiableLazyList(dataValues, this.getSerializationService());
    }

    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)"predicate can't be null");
        ClientMessage request = TransactionalMapValuesWithPredicateCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(predicate));
        ClientMessage response = this.invoke(request);
        List dataValues = TransactionalMapValuesWithPredicateCodec.decodeResponse((ClientMessage)response).response;
        ArrayList<Object> values = new ArrayList<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    void onDestroy() {
    }
}

