/*
 * Decompiled with CFR 0.152.
 */
package com.hyxt.data.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext = null;
    private static Logger logger = LoggerFactory.getLogger(SpringContextHolder.class);

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static void clearHolder() {
        logger.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.debug("\u6ce8\u5165ApplicationContext\u5230SpringContextHolder:" + applicationContext);
        if (SpringContextHolder.applicationContext != null) {
            logger.warn("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext);
        }
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    private static void assertContextInjected() {
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.");
    }
}

