/*
 * Decompiled with CFR 0.152.
 */
package com.hyxt.data.common.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TreeUtils {
    public static List mergerChildrenTree(List<? extends Treeable> treeList) {
        ArrayList resultList = new ArrayList();
        TreeUtils.mergerChildrenTree(treeList, resultList);
        return resultList;
    }

    private static void mergerChildrenTree(List<? extends Treeable> treeList, List targetList) {
        for (Treeable treeable : treeList) {
            targetList.add(treeable);
            if (treeable.getChildren() == null || treeable.getChildren().size() <= 0) continue;
            TreeUtils.mergerChildrenTree(treeable.getChildren(), targetList);
        }
    }

    public static List formatToTree(List<? extends Treeable> list) {
        ArrayList<Treeable> result = new ArrayList<Treeable>();
        for (Treeable treeable : list) {
            if (treeable.getParent() != null) continue;
            TreeUtils.mergeToParent(list, treeable);
            result.add(treeable);
        }
        return result;
    }

    private static void mergeToParent(List<? extends Treeable> list, Treeable parent) {
        if (null == list) {
            return;
        }
        parent.getChildren().clear();
        for (Treeable treeable : list) {
            if (!StringUtils.equals((CharSequence)treeable.getParentId(), (CharSequence)parent.getId())) continue;
            treeable.getChildren().clear();
            TreeUtils.mergeToParent(list, treeable);
            parent.getChildren().add(treeable);
        }
    }

    public static interface Treeable {
        public String getId();

        public String getName();

        public <T extends Treeable> T getParent();

        public String getParentId();

        public String getParentName();

        public <T extends Treeable> List<T> getChildren();
    }
}

