/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.ClasspathResourceLoader;

public class ClasspathResource
extends Resource {
    String path = null;
    File file = null;
    long lastModified = 0L;

    public ClasspathResource(String key, String path, ResourceLoader resourceLoader) {
        super(key, resourceLoader);
        this.path = path;
    }

    @Override
    public Reader openReader() {
        InputStream is;
        URL url = this.resourceLoader.getClass().getResource(this.path);
        if (url == null) {
            BeetlException be = new BeetlException("TEMPLATE_LOAD_ERROR");
            be.resourceId = this.id;
            throw be;
        }
        try {
            is = url.openStream();
        }
        catch (IOException e1) {
            BeetlException be = new BeetlException("TEMPLATE_LOAD_ERROR");
            be.resourceId = this.id;
            throw be;
        }
        if (is == null) {
            BeetlException be = new BeetlException("TEMPLATE_LOAD_ERROR");
            be.resourceId = this.id;
            throw be;
        }
        if (url.getProtocol().equals("file")) {
            this.file = new File(url.getFile());
            this.lastModified = this.file.lastModified();
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, ((ClasspathResourceLoader)this.resourceLoader).charset));
            return br;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public boolean isModified() {
        if (this.file != null) {
            return this.file.lastModified() != this.lastModified;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

