/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.Reader;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.engine.DefaultTemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AsmAAFactory;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.optimal.BlockStatementOptimal;
import org.beetl.core.statement.optimal.VarRefOptimal;

public class FastRuntimeEngine
extends DefaultTemplateEngine {
    public FastRuntimeEngine() {
        AABuilder.defalutAAFactory = new AsmAAFactory();
    }

    @Override
    public Program createProgram(Resource rs, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        Program program = super.createProgram(rs, reader, textMap, cr, gt);
        return program;
    }

    @Override
    protected GrammarCreator getGrammerCreator(GroupTemplate gt) {
        NewGrammarCreator grammar = new NewGrammarCreator();
        if (gt.getConf().isStrict()) {
            grammar.disable("VarAssign");
            grammar.disable("Function");
            grammar.disable("IncDec");
            grammar.disable("VarRefAssignExp");
            grammar.disable("VarRefAssign");
            grammar.disable("ClassNativeCall");
            grammar.disable("InstanceNativeCall");
            grammar.disable("Arth");
            grammar.disable("Compare");
            grammar.disable("InstanceNativeCall");
        }
        return grammar;
    }

    class NewGrammarCreator
    extends GrammarCreator {
        NewGrammarCreator() {
        }

        @Override
        public VarRef createVarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
            this.check("VarRefOptimal");
            if (attributes.length == 1 && !hasSafe) {
                VarRefOptimal express = new VarRefOptimal(attributes[0], token, firstToken);
                return express;
            }
            VarRef express = new VarRef(attributes, hasSafe, safe, firstToken);
            return express;
        }

        @Override
        public BlockStatement createBlock(Statement[] nodes, GrammarToken token) {
            if (nodes.length == 1) {
                return new BlockStatementOptimal(nodes, token);
            }
            BlockStatement block = new BlockStatement(nodes, token);
            return block;
        }
    }
}

