/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.annotations.Column;
import com.influxdb.annotations.Measurement;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.utils.Arguments;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class MeasurementMapper {
    private static final Logger LOG = Logger.getLogger(MeasurementMapper.class.getName());
    private static final ConcurrentMap<String, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap<String, ConcurrentMap<String, Field>>();

    @Nonnull
    <M> Point toPoint(@Nonnull M measurement, @Nonnull WritePrecision precision) throws InfluxException {
        Arguments.checkNotNull(measurement, (String)"measurement");
        Class<?> measurementType = measurement.getClass();
        this.cacheMeasurementClass(measurementType);
        Point point = Point.measurement(this.getMeasurementName(measurement, measurementType));
        for (Map.Entry entry : ((ConcurrentMap)CLASS_FIELD_CACHE.get(measurementType.getName())).entrySet()) {
            String name = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            Column column = field.getAnnotation(Column.class);
            if (column.measurement()) continue;
            Object value = this.getObject(measurement, field);
            if (value == null) {
                Object[] params = new Object[]{field.getName(), measurement};
                LOG.log(Level.FINEST, "Field {0} of {1} has null value", params);
                continue;
            }
            Class<?> fieldType = field.getType();
            if (column.tag()) {
                point.addTag(name, value.toString());
                continue;
            }
            if (column.timestamp()) {
                Instant instant = (Instant)value;
                point.time(instant, precision);
                continue;
            }
            if (this.isNumber(fieldType)) {
                point.addField(name, (Number)value);
                continue;
            }
            if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                point.addField(name, (Boolean)value);
                continue;
            }
            if (String.class.isAssignableFrom(fieldType)) {
                point.addField(name, (String)value);
                continue;
            }
            point.addField(name, value.toString());
        }
        LOG.log(Level.FINEST, "Mapped measurement: {0} to Point: {1}", new Object[]{measurement, point});
        return point;
    }

    @Nonnull
    private <M> String getMeasurementName(@Nonnull M measurement, @Nonnull Class<?> measurementType) {
        Measurement measurementAnnotation = measurementType.getAnnotation(Measurement.class);
        if (measurementAnnotation != null) {
            return measurementAnnotation.name();
        }
        Field measurementField = ((ConcurrentMap)CLASS_FIELD_CACHE.get(measurementType.getName())).values().stream().filter(field -> field.getAnnotation(Column.class).measurement()).findFirst().orElse(null);
        if (measurementField == null) {
            String message = String.format("Unable to determine Measurement for '%s'. Does it have a @Measurement annotation or field with @Column(measurement = true) annotation?", measurementType);
            throw new InfluxException(message);
        }
        return this.getObject(measurement, measurementField).toString();
    }

    private <M> Object getObject(@Nonnull M measurement, @Nonnull Field field) {
        Object value;
        try {
            field.setAccessible(true);
            value = field.get(measurement);
        }
        catch (IllegalAccessException e) {
            throw new InfluxException((Throwable)e);
        }
        return value;
    }

    private boolean isNumber(@Nonnull Class<?> fieldType) {
        return Number.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType) || Float.TYPE.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType);
    }

    private void cacheMeasurementClass(Class<?> ... measurementTypes) {
        for (Class<?> measurementType : measurementTypes) {
            if (CLASS_FIELD_CACHE.containsKey(measurementType.getName())) continue;
            ConcurrentHashMap<String, Field> map = new ConcurrentHashMap<String, Field>();
            for (Class<?> currentMeasurementType = measurementType; currentMeasurementType != null; currentMeasurementType = currentMeasurementType.getSuperclass()) {
                for (Field field : currentMeasurementType.getDeclaredFields()) {
                    Column colAnnotation = field.getAnnotation(Column.class);
                    if (colAnnotation == null) continue;
                    String name = colAnnotation.name();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    map.put(name, field);
                }
            }
            CLASS_FIELD_CACHE.putIfAbsent(measurementType.getName(), map);
        }
    }
}

