/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.ViewProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * TemplateChart
 */

public class TemplateChart {
  public static final String SERIALIZED_NAME_X_POS = "xPos";
  @SerializedName(SERIALIZED_NAME_X_POS)
  private Integer xPos;

  public static final String SERIALIZED_NAME_Y_POS = "yPos";
  @SerializedName(SERIALIZED_NAME_Y_POS)
  private Integer yPos;

  public static final String SERIALIZED_NAME_HEIGHT = "height";
  @SerializedName(SERIALIZED_NAME_HEIGHT)
  private Integer height;

  public static final String SERIALIZED_NAME_WIDTH = "width";
  @SerializedName(SERIALIZED_NAME_WIDTH)
  private Integer width;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  @JsonAdapter(TemplateChartPropertiesAdapter.class)
  private ViewProperties properties = null;

  public TemplateChart xPos(Integer xPos) {
    this.xPos = xPos;
    return this;
  }

   /**
   * Get xPos
   * @return xPos
  **/
  public Integer getXPos() {
    return xPos;
  }

  public void setXPos(Integer xPos) {
    this.xPos = xPos;
  }

  public TemplateChart yPos(Integer yPos) {
    this.yPos = yPos;
    return this;
  }

   /**
   * Get yPos
   * @return yPos
  **/
  public Integer getYPos() {
    return yPos;
  }

  public void setYPos(Integer yPos) {
    this.yPos = yPos;
  }

  public TemplateChart height(Integer height) {
    this.height = height;
    return this;
  }

   /**
   * Get height
   * @return height
  **/
  public Integer getHeight() {
    return height;
  }

  public void setHeight(Integer height) {
    this.height = height;
  }

  public TemplateChart width(Integer width) {
    this.width = width;
    return this;
  }

   /**
   * Get width
   * @return width
  **/
  public Integer getWidth() {
    return width;
  }

  public void setWidth(Integer width) {
    this.width = width;
  }

  public TemplateChart properties(ViewProperties properties) {
    this.properties = properties;
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  public ViewProperties getProperties() {
    return properties;
  }

  public void setProperties(ViewProperties properties) {
    this.properties = properties;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TemplateChart templateChart = (TemplateChart) o;
    return Objects.equals(this.xPos, templateChart.xPos) &&
        Objects.equals(this.yPos, templateChart.yPos) &&
        Objects.equals(this.height, templateChart.height) &&
        Objects.equals(this.width, templateChart.width) &&
        Objects.equals(this.properties, templateChart.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(xPos, yPos, height, width, properties);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TemplateChart {\n");
    sb.append("    xPos: ").append(toIndentedString(xPos)).append("\n");
    sb.append("    yPos: ").append(toIndentedString(yPos)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public static class TemplateChartPropertiesAdapter implements JsonDeserializer<Object>, JsonSerializer<Object> {

    public TemplateChartPropertiesAdapter() {
    }

    @Override
    public Object deserialize(final JsonElement json, final Type typeOfT, final JsonDeserializationContext context) throws JsonParseException {

      List<String> discriminator = Arrays.asList("timeFormat", "type", "shape");

      JsonObject jsonObject = json.getAsJsonObject();

      String[] types = discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);

      return deserialize(types, jsonObject, context);
    }

    @Override
    public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {

      return context.serialize(object);
    }

    private Object deserialize(final String[] types, final JsonElement json, final JsonDeserializationContext context) {

      if (Arrays.equals(new String[]{ "LinePlusSingleStatProperties", "line-plus-single-stat", "chronograf-v2" }, types)) {
        return context.deserialize(json, LinePlusSingleStatProperties.class);
      }
      if (Arrays.equals(new String[]{ "XYViewProperties", "xy", "chronograf-v2" }, types)) {
        return context.deserialize(json, XYViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "single-stat", "chronograf-v2" }, types)) {
        return context.deserialize(json, SingleStatViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "histogram", "chronograf-v2" }, types)) {
        return context.deserialize(json, HistogramViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "gauge", "chronograf-v2" }, types)) {
        return context.deserialize(json, GaugeViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "table", "chronograf-v2" }, types)) {
        return context.deserialize(json, TableViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "simple-table", "chronograf-v2" }, types)) {
        return context.deserialize(json, SimpleTableViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "markdown", "chronograf-v2" }, types)) {
        return context.deserialize(json, MarkdownViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "check", "chronograf-v2" }, types)) {
        return context.deserialize(json, CheckViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "ScatterViewProperties", "scatter", "chronograf-v2" }, types)) {
        return context.deserialize(json, ScatterViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "HeatmapViewProperties", "heatmap", "chronograf-v2" }, types)) {
        return context.deserialize(json, HeatmapViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "MosaicViewProperties", "mosaic", "chronograf-v2" }, types)) {
        return context.deserialize(json, MosaicViewProperties.class);
      }
      if (Arrays.equals(new String[]{ "BandViewProperties", "band", "chronograf-v2" }, types)) {
        return context.deserialize(json, BandViewProperties.class);
      }

      return context.deserialize(json, Object.class);
    }
  }
}

