/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Jpeg2000;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PatternColor;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamperImp;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfAcroForm;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfOCG;
import com.itextpdf.text.pdf.PdfOCProperties;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.ShadingColor;
import com.itextpdf.text.pdf.SpotColor;
import com.itextpdf.text.pdf.internal.PdfA1Checker;
import com.itextpdf.text.pdf.internal.PdfAChecker;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfA2Checker
extends PdfAChecker {
    public static final HashSet<PdfName> allowedBlendModes = new HashSet<PdfName>(Arrays.asList(PdfGState.BM_NORMAL, PdfGState.BM_COMPATIBLE, PdfGState.BM_MULTIPLY, PdfGState.BM_SCREEN, PdfGState.BM_OVERLAY, PdfGState.BM_DARKEN, PdfGState.BM_LIGHTEN, PdfGState.BM_COLORDODGE, PdfGState.BM_COLORBURN, PdfGState.BM_HARDLIGHT, PdfGState.BM_SOFTLIGHT, PdfGState.BM_DIFFERENCE, PdfGState.BM_EXCLUSION));
    public static final HashSet<PdfName> restrictedActions = new HashSet<PdfName>(Arrays.asList(PdfName.LAUNCH, PdfName.SOUND, PdfName.MOVIE, PdfName.RESETFORM, PdfName.IMPORTDATA, PdfName.HIDE, PdfName.SETOCGSTATE, PdfName.RENDITION, PdfName.TRANS, PdfName.GOTO3DVIEW, PdfName.JAVASCRIPT));
    private static HashSet<PdfName> allowedAnnotTypes = new HashSet<PdfName>(Arrays.asList(PdfName.TEXT, PdfName.LINK, PdfName.FREETEXT, PdfName.LINE, PdfName.SQUARE, PdfName.CIRCLE, PdfName.POLYGON, PdfName.POLYLINE, PdfName.HIGHLIGHT, PdfName.UNDERLINE, PdfName.SQUIGGLY, PdfName.STRIKEOUT, PdfName.STAMP, PdfName.CARET, PdfName.INK, PdfName.POPUP, PdfName.FILEATTACHMENT, PdfName.WIDGET, PdfName.PRINTERMARK, PdfName.TRAPNET, PdfName.WATERMARK, PdfName.REDACT));
    public static final HashSet<PdfName> contentAnnotations = new HashSet<PdfName>(Arrays.asList(PdfName.TEXT, PdfName.FREETEXT, PdfName.LINE, PdfName.SQUARE, PdfName.CIRCLE, PdfName.STAMP, PdfName.INK, PdfName.POPUP));
    private static final HashSet<PdfName> keysForCheck = new HashSet<PdfName>(Arrays.asList(PdfName.AP, PdfName.N, PdfName.R, PdfName.D, PdfName.FONTFILE, PdfName.FONTFILE2, PdfName.FONTFILE3, PdfName.NAME, PdfName.XFA, PdfName.ALTERNATEPRESENTATION, PdfName.DOCMDP, PdfName.REFERENCE, new PdfName("DigestLocation"), new PdfName("DigestMethod"), new PdfName("DigestValue"), PdfName.MARKED, PdfName.S, PdfName.SUBTYPE, PdfName.F));
    public static final PdfName DIGESTLOCATION = new PdfName("DigestLocation");
    public static final PdfName DIGESTMETHOD = new PdfName("DigestMethod");
    public static final PdfName DIGESTVALUE = new PdfName("DigestValue");
    static final int maxPageSize = 14400;
    static final int minPageSize = 3;
    protected int gsStackDepth = 0;
    protected boolean rgbUsed = false;
    protected boolean cmykUsed = false;
    protected boolean grayUsed = false;
    protected boolean transparencyWithoutPageGroupDetected = false;
    protected boolean transparencyDetectedOnThePage = false;
    public static final int maxStringLength = Short.MAX_VALUE;
    private static PdfName MimeTypePdf = new PdfName(PdfAWriter.MimeTypePdf);

    PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected HashSet<PdfName> initKeysForCheck() {
        return keysForCheck;
    }

    @Override
    protected void checkFont(PdfWriter writer, int key, Object obj1) {
        BaseFont bf = (BaseFont)obj1;
        if (bf.getFontType() == 4) {
            PdfStream prs = null;
            PdfDictionary fontDictionary = ((DocumentFont)bf).getFontDictionary();
            PdfDictionary fontDescriptor = this.getDirectDictionary(fontDictionary.get(PdfName.FONTDESCRIPTOR));
            if (fontDescriptor != null) {
                prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE));
                if (prs == null) {
                    prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE2));
                }
                if (prs == null) {
                    prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE3));
                }
            }
            if (prs == null) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"all.the.fonts.must.be.embedded.this.one.isn.t.1", (Object[])new Object[]{((BaseFont)obj1).getPostscriptFontName()}));
            }
        } else if (!bf.isEmbedded()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"all.the.fonts.must.be.embedded.this.one.isn.t.1", (Object[])new Object[]{((BaseFont)obj1).getPostscriptFontName()}));
        }
    }

    @Override
    protected void checkGState(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfObject) {
            PdfName ri;
            PdfDictionary smask;
            PdfNumber ca;
            PdfDictionary gs = this.getDirectDictionary((PdfObject)obj1);
            PdfObject obj = gs.get(PdfName.BM);
            if (obj != null) {
                if (!allowedBlendModes.contains(obj)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"blend.mode.1.not.allowed", (Object[])new Object[]{obj.toString()}));
                }
                if (!PdfGState.BM_NORMAL.equals((Object)obj)) {
                    this.transparencyDetectedOnThePage = true;
                }
            }
            if ((ca = gs.getAsNumber(PdfName.ca)) != null && ca.floatValue() < 1.0f) {
                this.transparencyDetectedOnThePage = true;
            }
            if ((ca = gs.getAsNumber(PdfName.CA)) != null && ca.floatValue() < 1.0f) {
                this.transparencyDetectedOnThePage = true;
            }
            if ((smask = this.getDirectDictionary(gs.get(PdfName.SMASK))) != null) {
                this.transparencyDetectedOnThePage = true;
            }
            if (gs.contains(PdfName.TR)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.tr.key", (Object[])new Object[0]));
            }
            PdfName tr2 = gs.getAsName(PdfName.TR2);
            if (tr2 != null && !tr2.equals((Object)PdfName.DEFAULT)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.TR2.key.with.a.value.other.than.default", (Object[])new Object[0]));
            }
            if (gs.contains(PdfName.HTP)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.htp.key", (Object[])new Object[0]));
            }
            PdfDictionary halfTone = this.getDirectDictionary(gs.get(PdfName.HT));
            if (halfTone != null) {
                if (halfTone.contains(PdfName.HALFTONENAME)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"halftones.shall.not.contains.halftonename", (Object[])new Object[0]));
                }
                PdfNumber halftoneType = halfTone.getAsNumber(PdfName.HALFTONETYPE);
                if (halftoneType == null || halftoneType.intValue() != 1 && halftoneType.intValue() != 5) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"all.halftones.shall.have.halftonetype.1.or.5", (Object[])new Object[0]));
                }
            }
            if (!((ri = gs.getAsName(PdfName.RI)) == null || PdfName.RELATIVECOLORIMETRIC.equals((Object)ri) || PdfName.ABSOLUTECOLORIMETRIC.equals((Object)ri) || PdfName.PERCEPTUAL.equals((Object)ri) || PdfName.SATURATION.equals((Object)ri))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"1.value.of.ri.key.is.not.allowed", (Object[])new Object[]{ri.toString()}));
            }
        }
    }

    @Override
    protected void checkImage(PdfWriter writer, int key, Object obj1) {
        PdfNumber smaskInData;
        PdfImage pdfImage = (PdfImage)obj1;
        if (this.getDirectStream(pdfImage.get(PdfName.SMASK)) != null) {
            this.transparencyDetectedOnThePage = true;
        }
        if ((smaskInData = pdfImage.getAsNumber(PdfName.SMASKINDATA)) != null && smaskInData.floatValue() > 0.0f) {
            this.transparencyDetectedOnThePage = true;
        }
        if (pdfImage.contains(PdfName.OPI)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.image.dictionary.shall.not.contain.opi.key", (Object[])new Object[0]));
        }
        PdfBoolean interpolate = pdfImage.getAsBoolean(PdfName.INTERPOLATE);
        if (interpolate != null && interpolate.booleanValue()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.value.of.interpolate.key.shall.not.be.true", (Object[])new Object[0]));
        }
        if (pdfImage != null && pdfImage.getImage() instanceof Jpeg2000) {
            Jpeg2000 jpeg2000 = (Jpeg2000)pdfImage.getImage();
            if (!jpeg2000.isJp2()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"only.jpx.baseline.set.of.features.shall.be.used", (Object[])new Object[0]));
            }
            if (jpeg2000.getNumOfComps() != 1 && jpeg2000.getNumOfComps() != 3 && jpeg2000.getNumOfComps() != 4) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.number.of.colour.channels.in.the.jpeg2000.data.shall.be.123", (Object[])new Object[0]));
            }
            if (jpeg2000.getBpc() < 1 || jpeg2000.getBpc() > 38) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.bit-depth.of.the.jpeg2000.data.shall.have.a.value.in.the.range.1to38", (Object[])new Object[0]));
            }
            if (jpeg2000.getBpcBoxData() != null) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"all.colour.channels.in.the.jpeg2000.data.shall.have.the.same.bit-depth", (Object[])new Object[0]));
            }
            ArrayList colorSpecBoxes = jpeg2000.getColorSpecBoxes();
            if (colorSpecBoxes != null) {
                if (colorSpecBoxes.size() > 1) {
                    int approx0x01 = 0;
                    for (Jpeg2000.ColorSpecBox colorSpecBox : colorSpecBoxes) {
                        if (colorSpecBox.getApprox() != 1) continue;
                        ++approx0x01;
                    }
                    if (approx0x01 != 1) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"exactly.one.colour.space.specification.shall.have.the.value.0x01.in.the.approx.field", (Object[])new Object[0]));
                    }
                }
                for (Jpeg2000.ColorSpecBox colorSpecBox : colorSpecBoxes) {
                    if (colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.value.of.the.meth.entry.in.colr.box.shall.be.123", (Object[])new Object[0]));
                    }
                    if (colorSpecBox.getEnumCs() == 19) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"jpeg2000.enumerated.colour.space.19.(CIEJab).shall.not.be.used", (Object[])new Object[0]));
                    }
                    byte[] colorProfileBytes = colorSpecBox.getColorProfile();
                    if (colorProfileBytes == null) continue;
                }
            }
        }
    }

    @Override
    protected void checkFormXObj(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfTemplate && ((PdfTemplate)obj1).getGroup() != null) {
            this.transparencyDetectedOnThePage = true;
        }
    }

    @Override
    protected void checkInlineImage(PdfWriter writer, int key, Object obj1) {
        PdfImage pdfImage = (PdfImage)obj1;
        PdfBoolean interpolate = pdfImage.getAsBoolean(PdfName.INTERPOLATE);
        if (interpolate != null && interpolate.booleanValue()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.value.of.interpolate.key.shall.not.be.true", (Object[])new Object[0]));
        }
        PdfObject filter = pdfImage.getDirectObject(PdfName.FILTER);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDECODE)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
            }
            if (filter.equals(PdfName.CRYPT)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"crypt.filter.is.not.permitted.inline.image", (Object[])new Object[0]));
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals((Object)PdfName.LZWDECODE)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
                }
                if (!f.equals((Object)PdfName.CRYPT)) continue;
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"crypt.filter.is.not.permitted.inline.image", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkLayer(PdfWriter writer, int key, Object obj1) {
        if (!(obj1 instanceof PdfOCG) && obj1 instanceof PdfOCProperties) {
            PdfArray configs;
            PdfOCProperties properties = (PdfOCProperties)obj1;
            ArrayList<PdfDictionary> configsList = new ArrayList<PdfDictionary>();
            PdfDictionary d = this.getDirectDictionary(properties.get(PdfName.D));
            if (d != null) {
                configsList.add(d);
            }
            if ((configs = this.getDirectArray(properties.get(PdfName.CONFIGS))) != null) {
                for (int i = 0; i < configs.size(); ++i) {
                    PdfDictionary config = this.getDirectDictionary(configs.getPdfObject(i));
                    if (config == null) continue;
                    configsList.add(config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = this.getDirectArray(properties.get(PdfName.OCGS));
            if (ocgsArray != null) {
                for (int i = 0; i < ocgsArray.size(); ++i) {
                    ocgs.add(ocgsArray.getPdfObject(i));
                }
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            for (PdfDictionary config : configsList) {
                PdfString name = config.getAsString(PdfName.NAME);
                if (name == null) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"optional.content.configuration.dictionary.shall.contain.name.entry", (Object[])new Object[0]));
                }
                String name1 = name.toUnicodeString();
                if (names.contains(name1)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"value.of.name.entry.shall.be.unique.amongst.all.optional.content.configuration.dictionaries", (Object[])new Object[0]));
                }
                names.add(name1);
                if (config.contains(PdfName.AS)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.as.key.shall.not.appear.in.any.optional.content.configuration.dictionary", (Object[])new Object[0]));
                }
                PdfArray orderArray = this.getDirectArray(config.get(PdfName.ORDER));
                if (orderArray == null) continue;
                this.fillOrderRecursively(orderArray, order);
            }
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"order.array.shall.contain.references.to.all.ocgs", (Object[])new Object[0]));
            }
            ocgs.retainAll(order);
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"order.array.shall.contain.references.to.all.ocgs", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkTrailer(PdfWriter writer, int key, Object obj1) {
        PdfWriter.PdfTrailer trailer;
        if (obj1 instanceof PdfWriter.PdfTrailer && (trailer = (PdfWriter.PdfTrailer)obj1).get(PdfName.ENCRYPT) != null) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"keyword.encrypt.shall.not.be.used.in.the.trailer.dictionary", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkStream(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfStream) {
            PdfStream stream = (PdfStream)obj1;
            if (stream.contains(PdfName.F) || stream.contains(PdfName.FFILTER) || stream.contains(PdfName.FDECODEPARMS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"stream.object.dictionary.shall.not.contain.the.f.ffilter.or.fdecodeparams.keys", (Object[])new Object[0]));
            }
            PdfObject filter = stream.getDirectObject(PdfName.FILTER);
            if (filter instanceof PdfName) {
                PdfString cryptFilterName;
                PdfDictionary decodeParams;
                if (filter.equals(PdfName.LZWDECODE)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
                }
                if (filter.equals(PdfName.CRYPT) && (decodeParams = this.getDirectDictionary(stream.get(PdfName.DECODEPARMS))) != null && (cryptFilterName = decodeParams.getAsString(PdfName.NAME)) != null && !cryptFilterName.equals(PdfName.IDENTITY)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"not.identity.crypt.filter.is.not.permitted", (Object[])new Object[0]));
                }
            } else if (filter instanceof PdfArray) {
                for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                    PdfDictionary decodeParam;
                    PdfString cryptFilterName;
                    PdfArray decodeParams;
                    PdfName f = ((PdfArray)filter).getAsName(i);
                    if (f.equals((Object)PdfName.LZWDECODE)) {
                        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
                    }
                    if (!f.equals((Object)PdfName.CRYPT) || (decodeParams = this.getDirectArray(stream.get(PdfName.DECODEPARMS))) == null || i >= decodeParams.size() || (cryptFilterName = (decodeParam = this.getDirectDictionary(decodeParams.getPdfObject(i))).getAsString(PdfName.NAME)) == null || cryptFilterName.equals(PdfName.IDENTITY)) continue;
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"not.identity.crypt.filter.is.not.permitted", (Object[])new Object[0]));
                }
            }
            if (PdfName.FORM.equals((Object)stream.getAsName(PdfName.SUBTYPE))) {
                if (stream.contains(PdfName.OPI)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.form.xobject.dictionary.shall.not.contain.opi.key", (Object[])new Object[0]));
                }
                if (stream.contains(PdfName.PS)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.form.xobject.dictionary.shall.not.contain.ps.key", (Object[])new Object[0]));
                }
            }
            if (PdfName.PS.equals((Object)stream.getAsName(PdfName.SUBTYPE))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"postscript.xobjects.are.not.allowed", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkFileSpec(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfFileSpecification) {
            PdfFileSpecification fileSpec = (PdfFileSpecification)obj1;
            if (!(fileSpec.contains(PdfName.UF) && fileSpec.contains(PdfName.F) && fileSpec.contains(PdfName.DESC))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"file.specification.dictionary.shall.contain.f.uf.and.desc.entries", (Object[])new Object[0]));
            }
            if (fileSpec.contains(PdfName.EF)) {
                PdfDictionary dict = this.getDirectDictionary(fileSpec.get(PdfName.EF));
                if (dict == null || !dict.contains(PdfName.F)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key", (Object[])new Object[0]));
                }
                PdfDictionary embeddedFile = this.getDirectDictionary(dict.get(PdfName.F));
                if (embeddedFile == null) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key", (Object[])new Object[0]));
                }
                this.checkEmbeddedFile(embeddedFile);
            }
        }
    }

    protected void checkEmbeddedFile(PdfDictionary embeddedFile) {
        PdfName subtype = embeddedFile.getAsName(PdfName.SUBTYPE);
        if (subtype == null || !MimeTypePdf.equals((Object)subtype)) {
            throw new PdfAConformanceException(embeddedFile, MessageLocalization.getComposedMessage((String)"embedded.file.shall.contain.pdf.mime.type", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void checkPdfObject(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfNumber) {
            PdfNumber number = (PdfNumber)obj1;
            if (!(Math.abs(number.doubleValue()) > 3.4028234663852886E38) || !number.toString().contains(".")) return;
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"real.number.is.out.of.range", (Object[])new Object[0]));
        }
        if (obj1 instanceof PdfString) {
            PdfString string = (PdfString)obj1;
            if (string.getBytes().length <= Short.MAX_VALUE) return;
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"pdf.string.is.too.long", (Object[])new Object[0]));
        }
        if (!(obj1 instanceof PdfDictionary)) return;
        PdfDictionary dictionary = (PdfDictionary)obj1;
        PdfName type = dictionary.getAsName(PdfName.TYPE);
        if (PdfName.CATALOG.equals((Object)type)) {
            PdfDictionary names;
            PdfDictionary acroForm;
            if (!dictionary.contains(PdfName.METADATA)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.contain.metadata", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.AA)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.an.aa.entry", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.REQUIREMENTS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.a.requirements.entry", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.NEEDRENDERING)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.a.needrendering.entry", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.ACROFORM) && (acroForm = this.getDirectDictionary(dictionary.get(PdfName.ACROFORM))) != null && acroForm.contains(PdfName.XFA)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.acroform.xfa.entry", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.NAMES) && (names = this.getDirectDictionary(dictionary.get(PdfName.NAMES))) != null && names.contains(PdfName.ALTERNATEPRESENTATION)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.alternatepresentation.names.entry", (Object[])new Object[0]));
            }
            PdfDictionary permissions = this.getDirectDictionary(dictionary.get(PdfName.PERMS));
            if (permissions != null) {
                for (PdfName dictKey : permissions.getKeys()) {
                    if (PdfName.DOCMDP.equals((Object)dictKey)) {
                        PdfArray references;
                        PdfDictionary signatureDict = this.getDirectDictionary(permissions.get(PdfName.DOCMDP));
                        if (signatureDict == null || (references = this.getDirectArray(signatureDict.get(PdfName.REFERENCE))) == null) continue;
                        for (int i = 0; i < references.size(); ++i) {
                            PdfDictionary referenceDict = this.getDirectDictionary(references.getPdfObject(i));
                            if (!referenceDict.contains(DIGESTLOCATION) && !referenceDict.contains(DIGESTMETHOD) && !referenceDict.contains(DIGESTVALUE)) continue;
                            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"signature.references.dictionary.shall.not.contain.digestlocation.digestmethod.digestvalue", (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (PdfName.UR3.equals((Object)dictKey)) continue;
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"no.keys.other.than.UR3.and.DocMDP.shall.be.present.in.a.permissions.dictionary", (Object[])new Object[0]));
                }
            }
            if (PdfA2Checker.checkStructure(this.conformanceLevel)) {
                PdfDictionary markInfo = this.getDirectDictionary(dictionary.get(PdfName.MARKINFO));
                if (markInfo == null || markInfo.getAsBoolean(PdfName.MARKED) == null || !markInfo.getAsBoolean(PdfName.MARKED).booleanValue()) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"document.catalog.dictionary.shall.include.a.markinfo.dictionary.whose.entry.marked.shall.have.a.value.of.true", (Object[])new Object[0]));
                }
                if (!dictionary.contains(PdfName.LANG)) {
                    this.LOGGER.warning(MessageLocalization.getComposedMessage((String)"document.catalog.dictionary.should.contain.lang.entry", (Object[])new Object[0]));
                }
            }
        } else if (PdfName.PAGE.equals((Object)type)) {
            PdfName[] boxNames;
            for (PdfName boxName : boxNames = new PdfName[]{PdfName.MEDIABOX, PdfName.CROPBOX, PdfName.TRIMBOX, PdfName.ARTBOX, PdfName.BLEEDBOX}) {
                PdfObject box = dictionary.getDirectObject(boxName);
                if (!(box instanceof PdfRectangle)) continue;
                float width = ((PdfRectangle)box).width();
                float height = ((PdfRectangle)box).height();
                if (!(width < 3.0f || width > 14400.0f || height < 3.0f) && !(height > 14400.0f)) continue;
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.page.less.3.units.nor.greater.14400.in.either.direction", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.AA)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"page.dictionary.shall.not.include.aa.entry", (Object[])new Object[0]));
            }
            if (dictionary.contains(PdfName.PRESSTEPS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"page.dictionary.shall.not.include.pressteps.entry", (Object[])new Object[0]));
            }
            if (this.transparencyDetectedOnThePage) {
                PdfDictionary group = this.getDirectDictionary(dictionary.get(PdfName.GROUP));
                if (group == null || !PdfName.TRANSPARENCY.equals((Object)group.getAsName(PdfName.S)) || !group.contains(PdfName.CS)) {
                    this.transparencyWithoutPageGroupDetected = true;
                } else {
                    PdfName csName = group.getAsName(PdfName.CS);
                    if (PdfName.DEVICERGB.equals((Object)csName)) {
                        this.rgbUsed = true;
                    }
                    if (PdfName.DEVICEGRAY.equals((Object)csName)) {
                        this.grayUsed = true;
                    }
                    if (PdfName.DEVICECMYK.equals((Object)csName)) {
                        this.cmykUsed = true;
                    }
                }
            }
            this.transparencyDetectedOnThePage = false;
        } else if (PdfName.OUTPUTINTENT.equals((Object)type)) {
            this.isCheckOutputIntent = true;
            PdfObject destOutputIntent = dictionary.get(PdfName.DESTOUTPUTPROFILE);
            if (destOutputIntent != null && this.pdfaDestOutputIntent != null) {
                if (this.pdfaDestOutputIntent.getIndRef() != destOutputIntent.getIndRef()) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"if.outputintents.array.more.than.one.entry.the.same.indirect.object", (Object[])new Object[0]));
                }
            } else {
                this.pdfaDestOutputIntent = destOutputIntent;
            }
            PdfName gts = dictionary.getAsName(PdfName.S);
            if (this.pdfaDestOutputIntent == null) throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"outputintent.shall.have.gtspdfa1.and.destoutputintent", (Object[])new Object[0]));
            if (PdfName.GTS_PDFA1.equals((Object)gts)) {
                if (this.pdfaOutputIntentColorSpace != null) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.pdfa.file.may.have.only.one.pdfa.outputintent", (Object[])new Object[0]));
                }
                this.pdfaOutputIntentColorSpace = "";
            }
            String deviceClass = "";
            ICC_Profile icc_profile = writer.getColorProfile();
            try {
                if (PdfName.GTS_PDFA1.equals((Object)gts)) {
                    this.pdfaOutputIntentColorSpace = new String(icc_profile.getData(), 16, 4, "US-ASCII");
                }
                deviceClass = new String(icc_profile.getData(), 12, 4, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new ExceptionConverter((Exception)e);
            }
            if (!"prtr".equals(deviceClass) && !"mntr".equals(deviceClass)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"outputintent.shall.be.prtr.or.mntr", (Object[])new Object[0]));
            }
        } else if (PdfName.EMBEDDEDFILE.equals((Object)type)) {
            this.checkEmbeddedFile(dictionary);
        }
        PdfObject obj2 = dictionary.get(PdfName.HALFTONETYPE);
        if (obj2 == null || !obj2.isNumber()) return;
        PdfNumber number = (PdfNumber)obj2;
        if (number.intValue() != 1 || number.intValue() != 5) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.contain.the.halftonetype.key.of.value.1.or.5", (Object[])new Object[0]));
        }
        if (!dictionary.contains(PdfName.HALFTONENAME)) return;
        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.halftonename.key", (Object[])new Object[0]));
    }

    @Override
    protected void checkCanvas(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof String) {
            if ("q".equals(obj1)) {
                if (++this.gsStackDepth > 28) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"graphics.state.stack.depth.is.greater.than.28", (Object[])new Object[0]));
                }
            } else if ("Q".equals(obj1)) {
                --this.gsStackDepth;
            }
        }
    }

    @Override
    protected void checkColor(PdfWriter writer, int key, Object obj1) {
        switch (key) {
            case 1: {
                if (obj1 instanceof ExtendedColor) {
                    ExtendedColor ec = (ExtendedColor)obj1;
                    switch (ec.getType()) {
                        case 2: {
                            this.checkColor(writer, 2, obj1);
                            break;
                        }
                        case 1: {
                            this.checkColor(writer, 18, obj1);
                            return;
                        }
                        case 0: {
                            this.checkColor(writer, 3, obj1);
                            break;
                        }
                        case 3: {
                            SpotColor sc = (SpotColor)ec;
                            this.checkColor(writer, 1, sc.getPdfSpotColor().getAlternativeCS());
                            break;
                        }
                        case 5: {
                            ShadingColor xc = (ShadingColor)ec;
                            this.checkColor(writer, 1, xc.getPdfShadingPattern().getShading().getColorSpace());
                            break;
                        }
                        case 4: {
                            PatternColor pc = (PatternColor)ec;
                            this.checkColor(writer, 1, pc.getPainter().getDefaultColor());
                        }
                    }
                    break;
                }
                if (!(obj1 instanceof BaseColor)) break;
                this.checkColor(writer, 3, obj1);
                break;
            }
            case 2: {
                this.cmykUsed = true;
                break;
            }
            case 3: {
                this.rgbUsed = true;
                break;
            }
            case 18: {
                this.grayUsed = true;
            }
        }
    }

    @Override
    protected void checkAnnotation(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfFormField) {
            PdfFormField field = (PdfFormField)obj1;
            if (!field.contains(PdfName.SUBTYPE)) {
                return;
            }
            if (field.contains(PdfName.AA) || field.contains(PdfName.A)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"widget.annotation.dictionary.or.field.dictionary.shall.not.include.a.or.aa.entry", (Object[])new Object[0]));
            }
        }
        if (obj1 instanceof PdfAnnotation) {
            PdfAnnotation annot = (PdfAnnotation)obj1;
            PdfObject subtype = annot.get(PdfName.SUBTYPE);
            if (subtype == null) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.type.1.not.allowed", (Object[])new Object[]{"null"}));
            }
            if (subtype != null && !allowedAnnotTypes.contains(subtype)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.type.1.not.allowed", (Object[])new Object[]{subtype.toString()}));
            }
            if (!PdfName.POPUP.equals((Object)annot.getAsName(PdfName.SUBTYPE))) {
                PdfNumber f = annot.getAsNumber(PdfName.F);
                if (f == null) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.annotation.dictionary.shall.contain.the.f.key", (Object[])new Object[0]));
                }
                int flags = f.intValue();
                if (!PdfA2Checker.checkFlag(flags, 4) || PdfA2Checker.checkFlag(flags, 2) || PdfA2Checker.checkFlag(flags, 1) || PdfA2Checker.checkFlag(flags, 32) || PdfA2Checker.checkFlag(flags, 256)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.f.keys.print.flag.bit.shall.be.set.to.1.and.its.hidden.invisible.noview.and.togglenoview.flag.bits.shall.be.set.to.0", (Object[])new Object[0]));
                }
                if (!(!PdfName.TEXT.equals((Object)annot.getAsName(PdfName.SUBTYPE)) || PdfA2Checker.checkFlag(flags, 8) && PdfA2Checker.checkFlag(flags, 16))) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"text.annotations.should.set.the.nozoom.and.norotate.flag.bits.of.the.f.key.to.1", (Object[])new Object[0]));
                }
            }
            if (PdfName.WIDGET.equals((Object)annot.getAsName(PdfName.SUBTYPE)) && (annot.contains(PdfName.AA) || annot.contains(PdfName.A))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"widget.annotation.dictionary.or.field.dictionary.shall.not.include.a.or.aa.entry", (Object[])new Object[0]));
            }
            if (PdfA2Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annot.contains(PdfName.CONTENTS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.of.type.1.should.have.contents.key", (Object[])new Object[]{subtype.toString()}));
            }
            PdfDictionary ap = this.getDirectDictionary(annot.get(PdfName.AP));
            if (ap != null) {
                if (ap.contains(PdfName.R) || ap.contains(PdfName.D)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"appearance.dictionary.shall.contain.only.the.n.key.with.stream.value", (Object[])new Object[0]));
                }
                PdfObject n = this.getDirectObject(ap.get(PdfName.N));
                if (PdfName.WIDGET.equals((Object)annot.getAsName(PdfName.SUBTYPE)) && new PdfName("Btn").equals((Object)annot.getAsName(PdfName.FT))) {
                    if (n == null || !n.isDictionary() && n.type() != 0) {
                        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"appearance.dictionary.of.widget.subtype.and.btn.field.type.shall.contain.only.the.n.key.with.dictionary.value", (Object[])new Object[0]));
                    }
                } else if (n == null || !n.isStream() && n.type() != 0) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"appearance.dictionary.shall.contain.only.the.n.key.with.stream.value", (Object[])new Object[0]));
                }
            } else {
                boolean isCorrectRect = false;
                PdfArray rect = this.getDirectArray(annot.get(PdfName.RECT));
                if (rect != null && rect.size() == 4) {
                    PdfNumber index0 = rect.getAsNumber(0);
                    PdfNumber index1 = rect.getAsNumber(1);
                    PdfNumber index2 = rect.getAsNumber(2);
                    PdfNumber index3 = rect.getAsNumber(3);
                    if (index0 != null && index1 != null && index2 != null && index3 != null && index0.doubleValue() == index2.doubleValue() && index1.doubleValue() == index3.doubleValue()) {
                        isCorrectRect = true;
                    }
                }
                if (!(PdfName.POPUP.equals((Object)annot.getAsName(PdfName.SUBTYPE)) || PdfName.LINK.equals((Object)annot.getAsName(PdfName.SUBTYPE)) || isCorrectRect)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"every.annotation.shall.have.at.least.one.appearance.dictionary", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void checkAction(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfAction) {
            PdfName n;
            PdfAction action = (PdfAction)obj1;
            PdfName s = action.getAsName(PdfName.S);
            if (PdfA1Checker.setState.equals((Object)s) || PdfA1Checker.noOp.equals((Object)s)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"deprecated.setstate.and.noop.actions.are.not.allowed", (Object[])new Object[0]));
            }
            if (restrictedActions.contains(s)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"launch.sound.movie.resetform.importdata.and.javascript.actions.are.not.allowed", (Object[])new Object[0]));
            }
            if (PdfName.NAMED.equals((Object)s) && (n = action.getAsName(PdfName.N)) != null && !PdfA1Checker.allowedNamedActions.contains(n)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"named.action.type.1.not.allowed", (Object[])new Object[]{n.toString()}));
            }
        }
    }

    @Override
    protected void checkForm(PdfWriter writer, int key, Object obj1) {
        PdfAcroForm form;
        PdfBoolean needAppearances;
        if (obj1 instanceof PdfAcroForm && (needAppearances = (form = (PdfAcroForm)obj1).getAsBoolean(PdfName.NEEDAPPEARANCES)) != null && needAppearances.booleanValue()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"needappearances.flag.of.the.interactive.form.dictionary.shall.either.not.be.present.or.shall.be.false", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkStructElem(PdfWriter writer, int key, Object obj1) {
        PdfObject o;
        PdfStructureElement structElem;
        PdfName role;
        if (obj1 instanceof PdfStructureElement && (PdfName.FIGURE.equals((Object)(role = (structElem = (PdfStructureElement)obj1).getStructureType())) || PdfName.FORMULA.equals((Object)role) || PdfName.FORM.equals((Object)role)) && (!((o = structElem.get(PdfName.ALT)) instanceof PdfString) || o.toString().length() <= 0)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"alt.entry.should.specify.alternate.description.for.1.element", (Object[])new Object[]{role.toString()}));
        }
    }

    @Override
    protected void checkOutputIntent(PdfWriter writer, int key, Object obj1) {
        if (writer instanceof PdfAStamperImp && writer.getColorProfile() != null) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"outputintent.shall.not.be.updated", (Object[])new Object[0]));
        }
    }

    private void fillOrderRecursively(PdfArray orderArray, HashSet<PdfObject> order) {
        for (int i = 0; i < orderArray.size(); ++i) {
            PdfArray orderChild = this.getDirectArray(orderArray.getPdfObject(i));
            if (orderChild == null) {
                order.add(orderArray.getPdfObject(i));
                continue;
            }
            this.fillOrderRecursively(orderChild, order);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close(PdfWriter writer) {
        this.checkOutputIntentsInStamperMode(writer);
        if (this.pdfaOutputIntentColorSpace != null) {
            if ("RGB ".equals(this.pdfaOutputIntentColorSpace)) {
                if (!this.cmykUsed || writer.getDefaultColorspace().get(PdfName.DEFAULTCMYK) != null) return;
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicecmyk.shall.only.be.used.if.defaultcmyk.pdfa.or.outputintent", (Object[])new Object[0]));
            }
            if ("CMYK".equals(this.pdfaOutputIntentColorSpace)) {
                if (!this.rgbUsed || writer.getDefaultColorspace().get(PdfName.DEFAULTRGB) != null) return;
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicergb.shall.only.be.used.if.defaultrgb.pdfa.or.outputintent", (Object[])new Object[0]));
            }
            if (!"GRAY".equals(this.pdfaOutputIntentColorSpace)) throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"outputintent.shall.have.colourspace.gray.rgb.or.cmyk", (Object[])new Object[0]));
            if (this.rgbUsed && writer.getDefaultColorspace().get(PdfName.DEFAULTRGB) == null) {
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicergb.shall.only.be.used.if.defaultrgb.pdfa.or.outputintent", (Object[])new Object[0]));
            }
            if (!this.cmykUsed || writer.getDefaultColorspace().get(PdfName.DEFAULTCMYK) != null) return;
            throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicecmyk.shall.only.be.used.if.defaultcmyk.pdfa.or.outputintent", (Object[])new Object[0]));
        }
        if (this.rgbUsed && writer.getDefaultColorspace().get(PdfName.DEFAULTRGB) == null) {
            throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicergb.shall.only.be.used.if.defaultrgb.pdfa.or.outputintent", (Object[])new Object[0]));
        }
        if (this.cmykUsed && writer.getDefaultColorspace().get(PdfName.DEFAULTCMYK) == null) {
            throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicecmyk.shall.only.be.used.if.defaultcmyk.pdfa.or.outputintent", (Object[])new Object[0]));
        }
        if (this.grayUsed && writer.getDefaultColorspace().get(PdfName.DEFAULTGRAY) == null) {
            throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicegray.shall.only.be.used.if.defaultgray.pdfa.or.outputintent", (Object[])new Object[0]));
        }
        if (!this.transparencyWithoutPageGroupDetected) return;
        throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"if.the.document.not.contain.outputintent.transparencygroup.shall.comtain.cs.key", (Object[])new Object[0]));
    }
}

