/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem;

import com.jeesuite.common.util.ResourceUtils;
import com.jeesuite.filesystem.FSProvider;
import com.jeesuite.filesystem.UploadObject;
import com.jeesuite.filesystem.UploadTokenParam;
import com.jeesuite.filesystem.provider.aliyun.AliyunossProvider;
import com.jeesuite.filesystem.provider.fdfs.FdfsProvider;
import com.jeesuite.filesystem.provider.qiniu.QiniuProvider;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class FileSystemClient {
    private static Map<String, FileSystemClient> clients = new HashMap<String, FileSystemClient>();
    private static final String PUBLIC_ID = ResourceUtils.getProperty((String)"public.filesystem.id", (String)"public");
    private static final String PRIVATE_ID = ResourceUtils.getProperty((String)"private.filesystem.id", (String)"private");
    private FSProvider fsProvider;

    private FileSystemClient(String id) {
        String provider = ResourceUtils.getProperty((String)(id + ".filesystem.provider"));
        Validate.notBlank((CharSequence)provider, (String)("[" + id + ".filesystem.provider] not defined"), (Object[])new Object[0]);
        boolean isPrivate = ResourceUtils.getBoolean((String)(id + ".filesystem.private"));
        String urlprefix = ResourceUtils.getProperty((String)(id + ".filesystem.urlprefix"));
        if ("qiniu".equals(provider)) {
            String bucketName = ResourceUtils.getProperty((String)(id + ".filesystem.bucketName"));
            String accessKey = ResourceUtils.getProperty((String)(id + ".filesystem.accessKey"));
            String secretKey = ResourceUtils.getProperty((String)(id + ".filesystem.secretKey"));
            this.fsProvider = new QiniuProvider(urlprefix, bucketName, accessKey, secretKey, isPrivate);
        } else if ("aliyun".equals(provider)) {
            String endpoint = ResourceUtils.getProperty((String)(id + ".filesystem.endpoint"));
            String bucketName = ResourceUtils.getProperty((String)(id + ".filesystem.bucketName"));
            String accessKey = ResourceUtils.getProperty((String)(id + ".filesystem.accessKey"));
            String secretKey = ResourceUtils.getProperty((String)(id + ".filesystem.secretKey"));
            this.fsProvider = new AliyunossProvider(urlprefix, endpoint, bucketName, accessKey, secretKey, isPrivate);
        } else if ("fastDFS".equals(provider)) {
            String groupName = ResourceUtils.getProperty((String)(id + ".filesystem.groupName"));
            String servers = ResourceUtils.getProperty((String)(id + ".filesystem.servers"));
            Validate.isTrue((servers != null && servers.matches("^.+[:]\\d{1,5}\\s*$") ? 1 : 0) != 0, (String)"[servers] is not valid", (Object[])new Object[0]);
            long connectTimeout = Long.parseLong(ResourceUtils.getProperty((String)(id + ".filesystem.connectTimeout"), (String)"3000"));
            int maxThreads = Integer.parseInt(ResourceUtils.getProperty((String)(id + ".filesystem.maxThreads"), (String)"50"));
            this.fsProvider = new FdfsProvider(urlprefix, groupName, servers.split(",|;"), connectTimeout, maxThreads);
        } else {
            throw new IllegalArgumentException("file provider ID:" + id + " not support");
        }
    }

    public static FileSystemClient getClient(String id) {
        return FileSystemClient.createClient(id);
    }

    public static FileSystemClient getPublicClient() {
        return FileSystemClient.createClient(PUBLIC_ID);
    }

    public static FileSystemClient getPrivateClient() {
        return FileSystemClient.createClient(PRIVATE_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystemClient createClient(String id) {
        FileSystemClient client = clients.get(id);
        if (client != null) {
            return client;
        }
        Map<String, FileSystemClient> map = clients;
        synchronized (map) {
            client = clients.get(id);
            if (client != null) {
                return client;
            }
            client = new FileSystemClient(id);
            clients.put(id, client);
        }
        return client;
    }

    public String upload(File file) {
        return this.fsProvider.upload(new UploadObject(file));
    }

    public String upload(String fileKey, File file) {
        return this.fsProvider.upload(new UploadObject(fileKey, file));
    }

    public String upload(String fileKey, File file, String catalog) {
        return this.fsProvider.upload(new UploadObject(fileKey, file).toCatalog(catalog));
    }

    public String upload(String fileKey, byte[] contents) {
        return this.fsProvider.upload(new UploadObject(fileKey, contents));
    }

    public String upload(String fileKey, byte[] contents, String catalog) {
        return this.fsProvider.upload(new UploadObject(fileKey, contents).toCatalog(catalog));
    }

    public String upload(String fileKey, InputStream in, String mimeType) {
        return this.fsProvider.upload(new UploadObject(fileKey, in, mimeType));
    }

    public String upload(String fileKey, InputStream in, String mimeType, String catalog) {
        return this.fsProvider.upload(new UploadObject(fileKey, in, mimeType).toCatalog(catalog));
    }

    public boolean delete(String fileKey) {
        return this.fsProvider.delete(fileKey);
    }

    public String getDownloadUrl(String fileKey) {
        return this.fsProvider.getDownloadUrl(fileKey);
    }

    public Map<String, Object> createUploadToken(UploadTokenParam param) {
        return this.fsProvider.createUploadToken(param);
    }

    public FSProvider getProvider() {
        return this.fsProvider;
    }
}

