/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem;

import com.jeesuite.filesystem.utils.FilePathHelper;
import com.jeesuite.filesystem.utils.MimeTypeFileExtensionConvert;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.lang3.StringUtils;

public class UploadObject {
    private String fileName;
    private String mimeType;
    private String catalog;
    private String url;
    private byte[] bytes;
    private File file;
    private InputStream inputStream;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public UploadObject(String filePath) {
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            this.url = filePath;
            this.fileName = FilePathHelper.parseFileName(this.url);
        } else {
            this.file = new File(filePath);
            this.fileName = this.file.getName();
        }
    }

    public UploadObject(File file) {
        this.fileName = file.getName();
        this.file = file;
    }

    public UploadObject(String fileName, File file) {
        this.fileName = fileName;
        this.file = file;
    }

    public UploadObject(String fileName, InputStream inputStream, String mimeType) {
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.mimeType = mimeType;
    }

    public UploadObject(String fileName, byte[] bytes, String mimeType) {
        this.fileName = fileName;
        this.bytes = bytes;
        this.mimeType = mimeType;
    }

    public UploadObject(String fileName, byte[] bytes) {
        this.fileName = fileName;
        this.bytes = bytes;
        this.mimeType = UploadObject.perseMimeType(bytes);
    }

    public String getFileName() {
        String fileExtension;
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            this.fileName = UUID.randomUUID().toString().replaceAll("\\-", "");
        }
        if (this.mimeType != null && !this.fileName.contains(".") && (fileExtension = MimeTypeFileExtensionConvert.getFileExtension(this.mimeType)) != null) {
            this.fileName = this.fileName + fileExtension;
        }
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setString(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public UploadObject addMetaData(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public UploadObject toCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    private static String perseMimeType(byte[] bytes) {
        try {
            MagicMatch match = Magic.getMagicMatch((byte[])bytes);
            String mimeType = match.getMimeType();
            return mimeType;
        }
        catch (Exception e) {
            return null;
        }
    }
}

