/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.provider.aliyun;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.jeesuite.filesystem.UploadObject;
import com.jeesuite.filesystem.UploadTokenParam;
import com.jeesuite.filesystem.provider.AbstractProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;

public class AliyunossProvider
extends AbstractProvider {
    public static final String NAME = "aliyun";
    private static final String URL_PREFIX_PATTERN = "(http).*\\.(com|cn)\\/";
    private static final String DEFAULT_CALLBACK_BODY = "filename=${object}&size=${size}&mimeType=${mimeType}&height=${imageInfo.height}&width=${imageInfo.width}";
    private OSSClient ossClient;
    private String bucketName;
    private String urlprefix;
    private boolean isPrivate;
    private String accessKeyId;
    private String host;

    public AliyunossProvider(String urlprefix, String endpoint, String bucketName, String accessKey, String secretKey, boolean isPrivate) {
        Validate.notBlank((CharSequence)endpoint, (String)"[endpoint] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bucketName, (String)"[bucketName] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)accessKey, (String)"[accessKey] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)secretKey, (String)"[secretKey] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)urlprefix, (String)"[urlprefix] not defined", (Object[])new Object[0]);
        this.accessKeyId = accessKey;
        this.ossClient = new OSSClient(endpoint, accessKey, secretKey);
        this.bucketName = bucketName;
        this.urlprefix = urlprefix.endsWith("/") ? urlprefix : urlprefix + "/";
        this.isPrivate = isPrivate;
        this.host = StringUtils.remove((String)urlprefix, (String)"/").split(":")[1];
        if (!this.ossClient.doesBucketExist(bucketName)) {
            System.out.println("Creating bucket " + bucketName + "\n");
            this.ossClient.createBucket(bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(isPrivate ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead);
            this.ossClient.createBucket(createBucketRequest);
        }
    }

    @Override
    public String upload(UploadObject object) {
        try {
            PutObjectRequest request = null;
            if (object.getFile() != null) {
                request = new PutObjectRequest(this.bucketName, object.getFileName(), object.getFile());
            } else if (object.getBytes() != null) {
                request = new PutObjectRequest(this.bucketName, object.getFileName(), (InputStream)new ByteArrayInputStream(object.getBytes()));
            } else if (object.getInputStream() != null) {
                request = new PutObjectRequest(this.bucketName, object.getFileName(), object.getInputStream());
            } else {
                throw new IllegalArgumentException("upload object is NULL");
            }
            PutObjectResult result = this.ossClient.putObject(request);
            if (result.getResponse() == null) {
                return this.isPrivate ? object.getFileName() : this.urlprefix + object.getFileName();
            }
            if (result.getResponse().isSuccessful()) {
                return result.getResponse().getUri();
            }
            throw new RuntimeException(result.getResponse().getErrorResponseAsString());
        }
        catch (OSSException e) {
            throw new RuntimeException(e.getErrorMessage());
        }
    }

    @Override
    public Map<String, Object> createUploadToken(UploadTokenParam param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PolicyConditions policyConds = new PolicyConditions();
        if (param.getFsizeMin() != null && param.getFsizeMax() != null) {
            policyConds.addConditionItem("content-length-range", param.getFsizeMin().longValue(), param.getFsizeMax().longValue());
        } else {
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        }
        if (param.getUploadDir() != null) {
            policyConds.addConditionItem(MatchMode.StartWith, "key", param.getUploadDir());
        }
        if (StringUtils.isBlank((CharSequence)param.getCallbackHost())) {
            param.setCallbackHost(this.host);
        }
        if (StringUtils.isBlank((CharSequence)param.getCallbackBody())) {
            param.setCallbackBody(DEFAULT_CALLBACK_BODY);
        }
        Date expire = DateUtils.addSeconds((Date)new Date(), (int)((int)param.getExpires()));
        String policy = this.ossClient.generatePostPolicy(expire, policyConds);
        String policyBase64 = null;
        String callbackBase64 = null;
        try {
            policyBase64 = BinaryUtil.toBase64String((byte[])policy.getBytes(StandardCharsets.UTF_8.name()));
            String callbackJson = param.getCallbackRuleAsJson();
            if (callbackJson != null) {
                callbackBase64 = BinaryUtil.toBase64String((byte[])callbackJson.getBytes(StandardCharsets.UTF_8.name()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String signature = this.ossClient.calculatePostSignature(policy);
        result.put("OSSAccessKeyId", this.accessKeyId);
        result.put("policy", policyBase64);
        result.put("signature", signature);
        result.put("host", this.urlprefix);
        result.put("dir", param.getUploadDir());
        result.put("expire", String.valueOf(expire.getTime()));
        if (callbackBase64 != null) {
            result.put("callback", callbackBase64);
        }
        return result;
    }

    @Override
    public boolean delete(String fileKey) {
        this.ossClient.deleteObject(this.bucketName, fileKey);
        return true;
    }

    @Override
    public String getDownloadUrl(String fileKey) {
        if (this.isPrivate) {
            URL url = this.ossClient.generatePresignedUrl(this.bucketName, fileKey, DateUtils.addHours((Date)new Date(), (int)1));
            return url.toString().replaceFirst(URL_PREFIX_PATTERN, this.urlprefix);
        }
        return this.urlprefix + fileKey;
    }

    @Override
    public void close() throws IOException {
        this.ossClient.shutdown();
    }

    @Override
    public String name() {
        return NAME;
    }
}

