/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.provider.fdfs;

import com.jeesuite.filesystem.UploadObject;
import com.jeesuite.filesystem.UploadTokenParam;
import com.jeesuite.filesystem.provider.AbstractProvider;
import com.jeesuite.filesystem.provider.FSOperErrorException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsClient;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FdfsProvider
extends AbstractProvider {
    public static final String NAME = "fastDFS";
    private FastdfsClient client;

    public FdfsProvider(String urlprefix, String bucketName, String[] servers, long connectTimeout, int maxThreads) {
        this.urlprefix = urlprefix.endsWith("/") ? urlprefix : urlprefix + "/";
        this.bucketName = bucketName;
        FastdfsClient.Builder builder = FastdfsClient.newBuilder().connectTimeout(connectTimeout).readTimeout(connectTimeout).maxThreads(maxThreads);
        for (String s : servers) {
            String[] tmpArray = s.split(":");
            builder.tracker(tmpArray[0], Integer.parseInt(tmpArray[1]));
        }
        this.client = builder.build();
    }

    @Override
    public String upload(UploadObject object) {
        CompletableFuture<FileId> upload = null;
        try {
            if (object.getFile() != null) {
                upload = this.client.upload(this.bucketName, object.getFile());
            } else if (object.getBytes() != null) {
                upload = this.client.upload(this.bucketName, object.getFileName(), object.getBytes());
            } else if (object.getInputStream() != null) {
                byte[] bs = IOUtils.toByteArray((InputStream)object.getInputStream());
                upload = this.client.upload(this.bucketName, object.getFileName(), bs);
            } else if (StringUtils.isNotBlank((CharSequence)object.getUrl())) {
                // empty if block
            }
            return this.getFullPath(upload.get().toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Map<String, Object> createUploadToken(UploadTokenParam param) {
        return null;
    }

    @Override
    public boolean delete(String fileKey) {
        try {
            if (fileKey.contains("/")) {
                fileKey = fileKey.replace(this.urlprefix, "");
            }
            FileId path = FileId.fromString(fileKey);
            this.client.delete(path).get();
            return true;
        }
        catch (Exception e) {
            this.processException(e);
            return false;
        }
    }

    @Override
    public String getDownloadUrl(String fileKey) {
        return this.getFullPath(fileKey);
    }

    @Override
    public String name() {
        return NAME;
    }

    private void processException(Exception e) {
        throw new FSOperErrorException(this.name(), e);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

