/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.provider.qiniu;

import com.jeesuite.filesystem.UploadObject;
import com.jeesuite.filesystem.UploadTokenParam;
import com.jeesuite.filesystem.provider.AbstractProvider;
import com.jeesuite.filesystem.provider.FSOperErrorException;
import com.jeesuite.filesystem.provider.qiniu.UploadResult;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class QiniuProvider
extends AbstractProvider {
    public static final String NAME = "qiniu";
    private static final String DEFAULT_CALLBACK_BODY = "filename=${fname}&size=${fsize}&mimeType=${mimeType}&height=${imageInfo.height}&width=${imageInfo.width}";
    private static final String[] policyFields = new String[]{"callbackUrl", "callbackBody", "callbackHost", "callbackBodyType", "fileType", "saveKey", "mimeLimit", "fsizeLimit", "fsizeMin", "deleteAfterDays"};
    private static UploadManager uploadManager;
    private static BucketManager bucketManager;
    private Auth auth;
    private boolean isPrivate;
    private String host;

    public QiniuProvider(String urlprefix, String bucketName, String accessKey, String secretKey, boolean isPrivate) {
        Validate.notBlank((CharSequence)bucketName, (String)"[bucketName] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)accessKey, (String)"[accessKey] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)secretKey, (String)"[secretKey] not defined", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)urlprefix, (String)"[urlprefix] not defined", (Object[])new Object[0]);
        this.urlprefix = urlprefix.endsWith("/") ? urlprefix : urlprefix + "/";
        this.bucketName = bucketName;
        this.auth = Auth.create((String)accessKey, (String)secretKey);
        Zone z = Zone.autoZone();
        Configuration c = new Configuration(z);
        uploadManager = new UploadManager(c);
        bucketManager = new BucketManager(this.auth, c);
        this.isPrivate = isPrivate;
        this.host = StringUtils.remove((String)urlprefix, (String)"/").split(":")[1];
    }

    @Override
    public String upload(UploadObject object) {
        String fileName = object.getFileName();
        if (StringUtils.isNotBlank((CharSequence)object.getCatalog())) {
            fileName = object.getCatalog().concat("/").concat(fileName);
        }
        try {
            Response res = null;
            String upToken = this.getUpToken(object.getMetadata());
            if (object.getFile() != null) {
                res = uploadManager.put(object.getFile(), fileName, upToken);
            } else if (object.getBytes() != null) {
                res = uploadManager.put(object.getBytes(), fileName, upToken);
            } else if (object.getInputStream() != null) {
                res = uploadManager.put(object.getInputStream(), fileName, upToken, null, object.getMimeType());
            } else {
                if (StringUtils.isNotBlank((CharSequence)object.getUrl())) {
                    return QiniuProvider.bucketManager.fetch((String)object.getUrl(), (String)this.bucketName, (String)fileName).key;
                }
                throw new IllegalArgumentException("upload object is NULL");
            }
            return this.processUploadResponse(res);
        }
        catch (QiniuException e) {
            this.processUploadException(fileName, e);
            return null;
        }
    }

    @Override
    public String getDownloadUrl(String fileKey) {
        String path = this.getFullPath(fileKey);
        if (this.isPrivate) {
            path = this.auth.privateDownloadUrl(path, 3600L);
        }
        return path;
    }

    @Override
    public boolean delete(String fileKey) {
        try {
            if (fileKey.contains("/")) {
                fileKey = fileKey.replace(this.urlprefix, "");
            }
            bucketManager.delete(this.bucketName, fileKey);
            return true;
        }
        catch (QiniuException e) {
            this.processUploadException(fileKey, e);
            return false;
        }
    }

    @Override
    public Map<String, Object> createUploadToken(UploadTokenParam param) {
        if (StringUtils.isNotBlank((CharSequence)param.getCallbackUrl())) {
            if (StringUtils.isBlank((CharSequence)param.getCallbackBody())) {
                param.setCallbackBody(DEFAULT_CALLBACK_BODY);
            }
            if (StringUtils.isBlank((CharSequence)param.getCallbackHost())) {
                param.setCallbackHost(this.host);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringMap policy = new StringMap();
        policy.putNotNull(policyFields[0], (Object)param.getCallbackUrl());
        policy.putNotNull(policyFields[1], (Object)param.getCallbackBody());
        policy.putNotNull(policyFields[2], (Object)param.getCallbackHost());
        policy.putNotNull(policyFields[3], (Object)param.getCallbackBodyType());
        policy.putNotNull(policyFields[4], (Object)param.getFileType());
        policy.putNotNull(policyFields[5], (Object)param.getFileKey());
        policy.putNotNull(policyFields[6], (Object)param.getMimeLimit());
        policy.putNotNull(policyFields[7], (Object)param.getFsizeMin());
        policy.putNotNull(policyFields[8], (Object)param.getFsizeMax());
        policy.putNotNull(policyFields[9], (Object)param.getDeleteAfterDays());
        String token = this.auth.uploadToken(this.bucketName, param.getFileKey(), param.getExpires(), policy, true);
        result.put("uptoken", token);
        result.put("host", this.urlprefix);
        result.put("dir", param.getUploadDir());
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String name() {
        return NAME;
    }

    private String processUploadResponse(Response res) throws QiniuException {
        if (res.isOK()) {
            UploadResult ret = (UploadResult)res.jsonToObject(UploadResult.class);
            return this.getFullPath(ret.key);
        }
        throw new FSOperErrorException(this.name(), res.toString());
    }

    private void processUploadException(String fileKey, QiniuException e) {
        String message;
        Response r = e.response;
        try {
            message = r.bodyString();
        }
        catch (Exception e2) {
            message = r.toString();
        }
        throw new FSOperErrorException(this.name(), e.code(), message);
    }

    private String getUpToken(Map<String, Object> metadata) {
        return this.auth.uploadToken(this.bucketName);
    }
}

