/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsExecutor;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsSettings;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.FileInfo;
import com.jeesuite.filesystem.sdk.fdfs.FileMetadata;
import com.jeesuite.filesystem.sdk.fdfs.StorageClient;
import com.jeesuite.filesystem.sdk.fdfs.StorageServer;
import com.jeesuite.filesystem.sdk.fdfs.TrackerClient;
import com.jeesuite.filesystem.sdk.fdfs.TrackerSelector;
import com.jeesuite.filesystem.sdk.fdfs.TrackerServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class FastdfsClient
implements Closeable {
    public static final long DEFAULT_CONNECT_TIMEOUT = 3000L;
    public static final long DEFAULT_READ_TIMEOUT = 3000L;
    public static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    public static final int DEFAULT_MAX_THREADS = 0;
    public static final int DEFAULT_MAX_CONN_PER_HOST = 100;
    private final FastdfsExecutor executor;
    private final TrackerClient trackerClient;
    private final StorageClient storageClient;

    private FastdfsClient(Builder builder) {
        FastdfsSettings settings = new FastdfsSettings(builder.connectTimeout, builder.readTimeout, builder.idleTimeout, builder.maxThreads, builder.maxConnPerHost);
        this.executor = new FastdfsExecutor(settings);
        this.trackerClient = new TrackerClient(this.executor, builder.selector, builder.trackers);
        this.storageClient = new StorageClient(this.executor);
    }

    public CompletableFuture<FileId> upload(File file) {
        return this.upload(null, file);
    }

    public CompletableFuture<FileId> upload(String group, File file) {
        Objects.requireNonNull(file, "file must not be null.");
        return this.trackerClient.uploadStorageGet(group).thenCompose(server -> this.storageClient.upload((StorageServer)server, file));
    }

    public CompletableFuture<FileId> upload(String filename, byte[] content) {
        return this.upload(null, filename, content);
    }

    public CompletableFuture<FileId> upload(String filename, byte[] content, FileMetadata metadata) {
        return this.upload(null, filename, content, metadata);
    }

    public CompletableFuture<FileId> upload(String group, String filename, byte[] content) {
        return this.upload(group, content, filename, content.length);
    }

    public CompletableFuture<FileId> upload(String group, String filename, byte[] content, FileMetadata metadata) {
        return this.upload(group, content, filename, content.length, metadata);
    }

    public CompletableFuture<FileId> upload(File file, FileMetadata metadata) {
        return this.upload(null, file, metadata);
    }

    public CompletableFuture<FileId> upload(String group, File file, FileMetadata metadata) {
        Objects.requireNonNull(file, "file must not be null.");
        Objects.requireNonNull(metadata, "metadata must not be null.");
        return this.upload(group, file).thenApply(fileId -> {
            this.metadataSet((FileId)fileId, metadata);
            return fileId;
        });
    }

    public CompletableFuture<FileId> upload(Object content, String filename, long size) {
        return this.upload(null, content, filename, size);
    }

    public CompletableFuture<FileId> upload(String group, Object content, String filename, long size) {
        Objects.requireNonNull(content, "content must not be null.");
        Objects.requireNonNull(filename, "filename must not be null.");
        return this.trackerClient.uploadStorageGet(group).thenCompose(server -> this.storageClient.upload((StorageServer)server, content, filename, size));
    }

    public CompletableFuture<FileId> upload(Object content, String filename, long size, FileMetadata metadata) {
        return this.upload(null, content, filename, size, metadata);
    }

    public CompletableFuture<FileId> upload(String group, Object content, String filename, long size, FileMetadata metadata) {
        Objects.requireNonNull(content, "content must not be null.");
        Objects.requireNonNull(filename, "filename must not be null.");
        Objects.requireNonNull(metadata, "metadata must not be null.");
        return this.upload(group, content, filename, size).thenApply(fileId -> {
            this.metadataSet((FileId)fileId, metadata);
            return fileId;
        });
    }

    public CompletableFuture<FileId> uploadAppender(File file) {
        return this.uploadAppender(null, file);
    }

    public CompletableFuture<FileId> uploadAppender(File file, FileMetadata metadata) {
        return this.uploadAppender(null, file, metadata);
    }

    public CompletableFuture<FileId> uploadAppender(String group, File file) {
        Objects.requireNonNull(file, "file must not be null.");
        return this.trackerClient.uploadStorageGet(group).thenCompose(server -> this.storageClient.uploadAppender((StorageServer)server, file));
    }

    public CompletableFuture<FileId> uploadAppender(String group, File file, FileMetadata metadata) {
        return this.uploadAppender(group, file).thenApply(fileId -> {
            this.metadataSet((FileId)fileId, metadata);
            return fileId;
        });
    }

    public CompletableFuture<FileId> uploadAppender(String filename, byte[] content) {
        return this.uploadAppender(null, content, filename, content.length);
    }

    public CompletableFuture<FileId> uploadAppender(String group, String filename, byte[] content) {
        return this.uploadAppender(group, content, filename, content.length);
    }

    public CompletableFuture<FileId> uploadAppender(String group, String filename, byte[] content, FileMetadata metadata) {
        return this.uploadAppender(group, content, filename, content.length, metadata);
    }

    public CompletableFuture<FileId> uploadAppender(Object content, String filename, long size) {
        return this.uploadAppender(null, content, filename, size);
    }

    public CompletableFuture<FileId> uploadAppender(Object content, String filename, long size, FileMetadata metadata) {
        return this.uploadAppender(null, content, filename, size, metadata);
    }

    public CompletableFuture<FileId> uploadAppender(String group, Object content, String filename, long size) {
        Objects.requireNonNull(content, "content must not be null.");
        Objects.requireNonNull(filename, "filename must not be null.");
        return this.trackerClient.uploadStorageGet(group).thenCompose(server -> this.storageClient.uploadAppender((StorageServer)server, content, filename, size));
    }

    public CompletableFuture<FileId> uploadAppender(String group, Object content, String filename, long size, FileMetadata metadata) {
        return this.uploadAppender(group, content, filename, size).thenApply(fileId -> {
            this.metadataSet((FileId)fileId, metadata);
            return fileId;
        });
    }

    public CompletableFuture<Void> download(String fileId, Object out) {
        return this.download(FileId.fromString(fileId), out);
    }

    public CompletableFuture<Void> download(FileId fileId, Object out) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(out, "out must not be null.");
        return this.trackerClient.downloadStorageGet(fileId).thenCompose(server -> this.storageClient.download((StorageServer)server, fileId, out));
    }

    public CompletableFuture<Void> download(String fileId, Object out, long offset, long size) {
        return this.download(FileId.fromString(fileId), out, offset, size);
    }

    public CompletableFuture<Void> download(FileId fileId, Object out, long offset, long size) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(out, "out must not be null.");
        return this.trackerClient.downloadStorageGet(fileId).thenCompose(server -> this.storageClient.download((StorageServer)server, fileId, out, offset, size));
    }

    public CompletableFuture<Void> delete(String fileId) {
        return this.delete(FileId.fromString(fileId));
    }

    public CompletableFuture<Void> delete(FileId fileId) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.delete((StorageServer)server, fileId));
    }

    public CompletableFuture<Void> append(String fileId, File file) {
        return this.append(FileId.fromString(fileId), file);
    }

    public CompletableFuture<Void> append(FileId fileId, File file) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(file, "file must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.append((StorageServer)server, fileId, file));
    }

    public CompletableFuture<Void> append(String fileId, byte[] bytes) {
        return this.append(FileId.fromString(fileId), bytes);
    }

    public CompletableFuture<Void> append(FileId fileId, byte[] bytes) {
        return this.append(fileId, (Object)bytes, (long)bytes.length);
    }

    public CompletableFuture<Void> append(String fileId, Object content, long size) {
        return this.append(FileId.fromString(fileId), content, size);
    }

    public CompletableFuture<Void> append(FileId fileId, Object content, long size) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(content, "content must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.append((StorageServer)server, fileId, content, size));
    }

    public CompletableFuture<Void> modify(String fileId, File file, long offset) {
        return this.modify(FileId.fromString(fileId), file, offset);
    }

    public CompletableFuture<Void> modify(FileId fileId, File file, long offset) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(file, "file must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.modify((StorageServer)server, fileId, file, offset));
    }

    public CompletableFuture<Void> modify(String fileId, byte[] bytes, long offset) {
        return this.modify(FileId.fromString(fileId), bytes, offset);
    }

    public CompletableFuture<Void> modify(FileId fileId, byte[] bytes, long offset) {
        return this.modify(fileId, (Object)bytes, (long)bytes.length, offset);
    }

    public CompletableFuture<Void> modify(String fileId, Object content, long size, long offset) {
        return this.modify(FileId.fromString(fileId), content, size, offset);
    }

    public CompletableFuture<Void> modify(FileId fileId, Object content, long size, long offset) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(content, "content must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.modify((StorageServer)server, fileId, content, size, offset));
    }

    public CompletableFuture<Void> truncate(String fileId) {
        return this.truncate(FileId.fromString(fileId));
    }

    public CompletableFuture<Void> truncate(FileId fileId) {
        return this.truncate(fileId, 0L);
    }

    public CompletableFuture<Void> truncate(String fileId, long truncatedSize) {
        return this.truncate(FileId.fromString(fileId), truncatedSize);
    }

    public CompletableFuture<Void> truncate(FileId fileId, long truncatedSize) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.truncate((StorageServer)server, fileId, truncatedSize));
    }

    public CompletableFuture<Void> metadataSet(String fileId, FileMetadata metadata) {
        return this.metadataSet(FileId.fromString(fileId), metadata);
    }

    public CompletableFuture<Void> metadataSet(FileId fileId, FileMetadata metadata) {
        return this.metadataSet(fileId, metadata, FileMetadata.OVERWRITE_FLAG);
    }

    public CompletableFuture<Void> metadataSet(String fileId, FileMetadata metadata, byte flag) {
        return this.metadataSet(FileId.fromString(fileId), metadata, flag);
    }

    public CompletableFuture<Void> metadataSet(FileId fileId, FileMetadata metadata, byte flag) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        Objects.requireNonNull(metadata, "metadata must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.setMetadata((StorageServer)server, fileId, metadata, flag));
    }

    public CompletableFuture<FileMetadata> metadataGet(String fileId) {
        return this.metadataGet(FileId.fromString(fileId));
    }

    public CompletableFuture<FileMetadata> metadataGet(FileId fileId) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.getMetadata((StorageServer)server, fileId));
    }

    public CompletableFuture<FileInfo> infoGet(String fileId) {
        return this.infoGet(FileId.fromString(fileId));
    }

    public CompletableFuture<FileInfo> infoGet(FileId fileId) {
        Objects.requireNonNull(fileId, "fileId must not be null.");
        return this.trackerClient.updateStorageGet(fileId).thenCompose(server -> this.storageClient.getInfo((StorageServer)server, fileId));
    }

    @Override
    public void close() throws IOException {
        this.executor.close();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        long connectTimeout = 3000L;
        long readTimeout = 3000L;
        long idleTimeout = 60000L;
        int maxThreads = 0;
        int maxConnPerHost = 100;
        TrackerSelector selector = TrackerSelector.RANDOM;
        List<TrackerServer> trackers = new LinkedList<TrackerServer>();

        Builder() {
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder idleTimeout(long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder maxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder maxConnPerHost(int maxConnPerHost) {
            this.maxConnPerHost = maxConnPerHost;
            return this;
        }

        public Builder selector(TrackerSelector selector) {
            this.selector = Objects.requireNonNull(selector, "selector must not be null.");
            return this;
        }

        public Builder trackers(List<TrackerServer> servers) {
            this.trackers = new LinkedList<TrackerServer>((Collection)Objects.requireNonNull(servers, "servers must not be null."));
            return this;
        }

        public Builder tracker(TrackerServer server) {
            this.trackers.add(Objects.requireNonNull(server, "server must not be null."));
            return this;
        }

        public Builder tracker(String host, int port) {
            return this.tracker(new TrackerServer(host, port));
        }

        public Builder tracker(String host, int port, int weight) {
            return this.tracker(new TrackerServer(host, port, weight));
        }

        public FastdfsClient build() {
            return new FastdfsClient(this);
        }
    }
}

