/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsOperation;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsPool;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsPoolGroup;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsSettings;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import com.jeesuite.filesystem.sdk.fdfs.exchange.ReplierDecoder;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import com.jeesuite.filesystem.sdk.fdfs.exchange.RequestorEncoder;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FastdfsExecutor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FastdfsExecutor.class);
    private final EventLoopGroup loopGroup;
    private final FastdfsPoolGroup poolGroup;

    FastdfsExecutor(FastdfsSettings settings) {
        this.loopGroup = new NioEventLoopGroup(settings.maxThreads());
        this.poolGroup = new FastdfsPoolGroup(this.loopGroup, settings.connectTimeout(), settings.readTimeout(), settings.idleTimeout(), settings.maxConnPerHost());
    }

    <T> CompletableFuture<T> execute(InetSocketAddress addr, Requestor.Encoder encoder, Replier.Decoder<T> decoder) {
        return this.execute(addr, new RequestorEncoder(encoder), new ReplierDecoder<T>(decoder));
    }

    <T> CompletableFuture<T> execute(InetSocketAddress addr, Requestor.Encoder encoder, Replier<T> replier) {
        return this.execute(addr, new RequestorEncoder(encoder), replier);
    }

    <T> CompletableFuture<T> execute(InetSocketAddress addr, Requestor requestor, Replier<T> replier) {
        CompletableFuture promise = new CompletableFuture();
        this.execute(addr, requestor, replier, promise);
        return promise;
    }

    private <T> void execute(InetSocketAddress addr, Requestor requestor, Replier<T> replier, CompletableFuture<T> promise) {
        FastdfsPool pool = (FastdfsPool)this.poolGroup.get(addr);
        pool.acquire().addListener(new FastdfsChannelListener<T>(pool, requestor, replier, promise));
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (null != this.poolGroup) {
            try {
                this.poolGroup.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.loopGroup) {
            this.loopGroup.shutdownGracefully();
        }
    }

    private static class FastdfsChannelListener<T>
    implements FutureListener<Channel> {
        final FastdfsPool pool;
        final Requestor requestor;
        final Replier<T> replier;
        final CompletableFuture<T> promise;

        FastdfsChannelListener(FastdfsPool pool, Requestor requestor, Replier<T> replier, CompletableFuture<T> promise) {
            this.pool = pool;
            this.requestor = requestor;
            this.replier = replier;
            this.promise = promise;
        }

        public void operationComplete(Future<Channel> cf) throws Exception {
            if (cf.isCancelled()) {
                this.promise.cancel(true);
                return;
            }
            if (!cf.isSuccess()) {
                this.promise.completeExceptionally(cf.cause());
                return;
            }
            Channel channel = (Channel)cf.getNow();
            this.promise.whenComplete((result, error) -> this.pool.release(channel));
            try {
                FastdfsOperation<T> fastdfsOperation = new FastdfsOperation<T>(channel, this.requestor, this.replier, this.promise);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("execute {}", fastdfsOperation);
                }
                fastdfsOperation.execute();
            }
            catch (Exception e) {
                this.promise.completeExceptionally(e);
            }
        }
    }
}

