/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsDataOverflowException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsOperation;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsReadTimeoutException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsTimeoutException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FastdfsHandler
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(FastdfsHandler.class);
    private volatile FastdfsOperation<?> operation;

    FastdfsHandler() {
    }

    void operation(FastdfsOperation<?> operation) {
        this.operation = operation;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (null != this.operation) {
            this.operation.await(in);
            return;
        }
        if (in.readableBytes() <= 0) {
            return;
        }
        throw new FastdfsDataOverflowException(String.format("fastdfs channel %s remain %s data bytes, but there is not operation await.", ctx.channel(), in.readableBytes()));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT || evt == IdleStateEvent.READER_IDLE_STATE_EVENT) {
            if (null != this.operation) {
                throw new FastdfsReadTimeoutException(String.format("execute %s read timeout.", this.operation));
            }
            return;
        }
        if (evt == IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT || evt == IdleStateEvent.ALL_IDLE_STATE_EVENT) {
            throw new FastdfsTimeoutException("fastdfs channel was idle timeout.");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (null == this.operation) {
            return;
        }
        if (!this.operation.isDone()) {
            throw new FastdfsException("channel closed.");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        Throwable error = this.translateException(cause);
        if (null != this.operation) {
            this.operation.caught(error);
            return;
        }
        if (error instanceof FastdfsTimeoutException) {
            LOG.debug(error.getMessage(), error);
            return;
        }
        LOG.error(error.getMessage(), error);
    }

    private Throwable translateException(Throwable cause) {
        if (cause instanceof FastdfsException) {
            return cause;
        }
        Throwable unwrap = cause;
        while (true) {
            if (unwrap instanceof InvocationTargetException) {
                unwrap = ((InvocationTargetException)unwrap).getTargetException();
                continue;
            }
            if (!(unwrap instanceof UndeclaredThrowableException)) break;
            unwrap = ((UndeclaredThrowableException)unwrap).getUndeclaredThrowable();
        }
        return new FastdfsException("fastdfs operation error.", unwrap);
    }
}

