/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsHandler;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;

final class FastdfsOperation<T> {
    private final Channel channel;
    private final Requestor requestor;
    private final Replier<T> replier;
    private final CompletableFuture<T> promise;

    FastdfsOperation(Channel channel, Requestor requestor, Replier<T> replier, CompletableFuture<T> promise) {
        this.channel = channel;
        this.requestor = requestor;
        this.replier = replier;
        this.promise = promise;
    }

    void execute() {
        ((FastdfsHandler)this.channel.pipeline().get(FastdfsHandler.class)).operation(this);
        try {
            this.requestor.request(this.channel);
        }
        catch (Exception e) {
            this.caught(e);
        }
    }

    boolean isDone() {
        return this.promise.isDone();
    }

    void await(ByteBuf in) {
        try {
            this.replier.reply(in, this.promise);
        }
        catch (Exception e) {
            this.caught(e);
        }
    }

    void caught(Throwable cause) {
        this.promise.completeExceptionally(cause);
    }

    public String toString() {
        return "FastdfsOperation{channel=" + this.channel + ", replier=" + this.replier + ", requestor=" + this.requestor + '}';
    }
}

