/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsHandler;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsPoolGroup;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FastdfsPool
implements ChannelPool {
    private static final Logger LOG = LoggerFactory.getLogger(FastdfsPoolGroup.class);
    private final ChannelPool channelPool;

    FastdfsPool(Bootstrap bootstrap, long readTimeout, long idleTimeout, int maxConnPerHost) {
        this.channelPool = new FixedChannelPool(bootstrap, (ChannelPoolHandler)new FastdfsPoolHandler(readTimeout, idleTimeout), maxConnPerHost);
    }

    public Future<Channel> acquire() {
        return this.channelPool.acquire();
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.channelPool.release(channel, promise);
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.channelPool.acquire(promise);
    }

    public void close() {
        this.channelPool.close();
    }

    public Future<Void> release(Channel channel) {
        return this.channelPool.release(channel);
    }

    private static class FastdfsPoolHandler
    implements ChannelPoolHandler {
        final long readTimeout;
        final long idleTimeout;

        FastdfsPoolHandler(long readTimeout, long idleTimeout) {
            this.readTimeout = readTimeout;
            this.idleTimeout = idleTimeout;
        }

        public void channelReleased(Channel channel) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("channel released : {}", (Object)channel.toString());
            }
            ((FastdfsHandler)channel.pipeline().get(FastdfsHandler.class)).operation(null);
        }

        public void channelAcquired(Channel channel) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("channel acquired : {}", (Object)channel.toString());
            }
            ((FastdfsHandler)channel.pipeline().get(FastdfsHandler.class)).operation(null);
        }

        public void channelCreated(Channel channel) throws Exception {
            if (LOG.isInfoEnabled()) {
                LOG.info("channel created : {}", (Object)channel.toString());
            }
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.readTimeout, 0L, this.idleTimeout, TimeUnit.MILLISECONDS)});
            pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(new ChannelHandler[]{new FastdfsHandler()});
        }
    }
}

