/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsPool;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FastdfsPoolGroup
extends AbstractChannelPoolMap<InetSocketAddress, FastdfsPool> {
    private static final Logger LOG = LoggerFactory.getLogger(FastdfsPoolGroup.class);
    private final EventLoopGroup loopGroup;
    private final long connectTimeout;
    private final long readTimeout;
    private final long idleTimeout;
    private final int maxConnPerHost;

    FastdfsPoolGroup(EventLoopGroup loopGroup, long connectTimeout, long readTimeout, long idleTimeout, int maxConnPerHost) {
        this.loopGroup = loopGroup;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.idleTimeout = idleTimeout;
        this.maxConnPerHost = maxConnPerHost;
    }

    protected FastdfsPool newPool(InetSocketAddress addr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("channel pool created : {}", (Object)addr);
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.loopGroup);
        bootstrap.remoteAddress((SocketAddress)addr);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.connectTimeout));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return new FastdfsPool(bootstrap, this.readTimeout, this.idleTimeout, this.maxConnPerHost);
    }
}

