/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.util.Collection;
import java.util.List;

public final class FastdfsUtils {
    private FastdfsUtils() {
    }

    public static boolean isEmpty(String content) {
        return content == null || content.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> coll) {
        return coll == null || coll.isEmpty();
    }

    public static <T> T first(List<T> list) {
        return FastdfsUtils.isEmpty(list) ? null : (T)list.get(0);
    }

    public static void writeFixLength(ByteBuf buf, String content, int length) {
        byte[] bytes = content.getBytes(CharsetUtil.UTF_8);
        int blen = bytes.length;
        int wlen = blen > length ? length : blen;
        buf.writeBytes(bytes, 0, wlen);
        if (wlen < length) {
            buf.writeZero(length - wlen);
        }
    }

    public static String readString(ByteBuf in, int length) {
        return in.readBytes(length).toString(CharsetUtil.UTF_8).trim();
    }

    public static String readString(ByteBuf in) {
        return in.toString(CharsetUtil.UTF_8);
    }

    public static String getFileExt(String filename) {
        if (filename == null) {
            return "";
        }
        int idx = filename.lastIndexOf(46);
        return idx == -1 ? "" : filename.substring(idx + 1).toLowerCase();
    }

    public static String getFileExt(String filename, String defaultExt) {
        String fileExt = FastdfsUtils.getFileExt(filename);
        return FastdfsUtils.isEmpty(fileExt) ? defaultExt : fileExt;
    }
}

