/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsConstants;
import java.util.Base64;
import java.util.Objects;

public class FileId {
    private static final char SEPARATER = '/';
    private final String group;
    private final String path;

    public FileId(String group, String path) {
        this.group = Objects.requireNonNull(group, "group must not be null.");
        this.path = Objects.requireNonNull(path, "path must not be null.");
    }

    public String group() {
        return this.group;
    }

    public byte[] groupBytes() {
        return this.group.getBytes(FastdfsConstants.UTF_8);
    }

    public String path() {
        return this.path;
    }

    public byte[] pathBytes() {
        return this.path.getBytes(FastdfsConstants.UTF_8);
    }

    public byte[] toBytes() {
        return this.toString().getBytes(FastdfsConstants.UTF_8);
    }

    public String toString() {
        return this.group + '/' + this.path;
    }

    public String toBase64String() {
        return Base64.getUrlEncoder().encodeToString(this.toBytes());
    }

    public static FileId fromString(String fullPath) {
        if (fullPath == null || fullPath.length() == 0) {
            throw new IllegalArgumentException("fullPath should not be empty.");
        }
        int idx = fullPath.indexOf(47);
        if (idx < 0) {
            throw new IllegalArgumentException("fullPath cannot find path separater.");
        }
        String group = fullPath.substring(0, idx);
        String path = fullPath.substring(idx + 1);
        return new FileId(group, path);
    }

    public static FileId fromBase64String(String base64) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64.getBytes(FastdfsConstants.UTF_8));
        return FileId.fromString(new String(bytes));
    }
}

