/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileMetadata {
    public static byte OVERWRITE_FLAG = (byte)79;
    public static byte MERGE_FLAG = (byte)77;
    private final Map<String, String> values;

    private FileMetadata(Builder builder) {
        this.values = builder.values;
    }

    public FileMetadata(Map<String, String> values) {
        this.values = new HashMap<String, String>(values);
    }

    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "FileMetadata{values=" + this.values + '}';
    }

    public byte[] toBytes(Charset charset) {
        if (this.values.isEmpty()) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            if (!first) {
                sb.append("\u0001");
            }
            sb.append(entry.getKey());
            sb.append("\u0002");
            sb.append(entry.getValue());
            first = false;
        }
        return sb.toString().getBytes(charset);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        Map<String, String> values = new HashMap<String, String>();

        Builder() {
        }

        public Builder put(String name, String value) {
            this.values.put(name, value);
            return this;
        }

        public Builder putAll(Map<String, String> values) {
            this.values.putAll(values);
            return this;
        }

        public FileMetadata build() {
            return new FileMetadata(this);
        }
    }
}

