/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsExecutor;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.FileInfo;
import com.jeesuite.filesystem.sdk.fdfs.FileMetadata;
import com.jeesuite.filesystem.sdk.fdfs.StorageServer;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileAppendEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileDeleteEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileDownloadEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileIdDecoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileInfoDecoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileInfoGetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileMetadataDecoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileMetadataGetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileMetadataSetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileModifyEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileTruncateEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileUploadAppenderEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileUploadEncoder;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import com.jeesuite.filesystem.sdk.fdfs.exchange.StreamReplier;
import java.io.File;
import java.util.concurrent.CompletableFuture;

final class StorageClient {
    private final FastdfsExecutor executor;

    StorageClient(FastdfsExecutor executor) {
        this.executor = executor;
    }

    CompletableFuture<FileId> upload(StorageServer server, File file) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileUploadEncoder(file, server.pathIdx()), FileIdDecoder.INSTANCE);
    }

    CompletableFuture<FileId> upload(StorageServer server, Object content, String filename, long size) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileUploadEncoder(content, filename, size, server.pathIdx()), FileIdDecoder.INSTANCE);
    }

    CompletableFuture<FileId> uploadAppender(StorageServer server, File file) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileUploadAppenderEncoder(file, server.pathIdx()), FileIdDecoder.INSTANCE);
    }

    CompletableFuture<FileId> uploadAppender(StorageServer server, Object content, String filename, long size) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileUploadAppenderEncoder(content, filename, size, server.pathIdx()), FileIdDecoder.INSTANCE);
    }

    CompletableFuture<Void> append(StorageServer server, FileId fileId, File file) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileAppendEncoder(fileId, file), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> append(StorageServer server, FileId fileId, byte[] bytes) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileAppendEncoder(fileId, bytes, bytes.length), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> append(StorageServer server, FileId fileId, Object content, long size) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileAppendEncoder(fileId, content, size), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> modify(StorageServer server, FileId fileId, File file, long offset) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileModifyEncoder(fileId, file, offset), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> modify(StorageServer server, FileId fileId, byte[] bytes, long offset) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileModifyEncoder(fileId, bytes, bytes.length, offset), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> modify(StorageServer server, FileId fileId, Object content, long size, long offset) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileModifyEncoder(fileId, content, size, offset), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> delete(StorageServer server, FileId fileId) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileDeleteEncoder(fileId), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> truncate(StorageServer server, FileId fileId) {
        return this.truncate(server, fileId, 0L);
    }

    CompletableFuture<Void> truncate(StorageServer server, FileId fileId, long truncatedSize) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileTruncateEncoder(fileId, truncatedSize), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<Void> download(StorageServer server, FileId fileId, Object output) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileDownloadEncoder(fileId), StreamReplier.stream(output));
    }

    CompletableFuture<Void> download(StorageServer server, FileId fileId, Object output, long offset, long size) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileDownloadEncoder(fileId, offset, size), StreamReplier.stream(output));
    }

    CompletableFuture<Void> setMetadata(StorageServer server, FileId fileId, FileMetadata metadata, byte flag) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileMetadataSetEncoder(fileId, metadata, flag), Replier.NOPDecoder.INSTANCE);
    }

    CompletableFuture<FileMetadata> getMetadata(StorageServer server, FileId fileId) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileMetadataGetEncoder(fileId), FileMetadataDecoder.INSTANCE);
    }

    CompletableFuture<FileInfo> getInfo(StorageServer server, FileId fileId) {
        return this.executor.execute(server.toInetAddress(), (Requestor.Encoder)new FileInfoGetEncoder(fileId), FileInfoDecoder.INSTANCE);
    }
}

