/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsExecutor;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.StorageServer;
import com.jeesuite.filesystem.sdk.fdfs.TrackerSelector;
import com.jeesuite.filesystem.sdk.fdfs.TrackerServer;
import com.jeesuite.filesystem.sdk.fdfs.codec.DownloadStorageGetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.DownloadStorageListEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.StorageServerDecoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.StorageServerListDecoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.UpdateStorageGetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.codec.UploadStorageGetEncoder;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TrackerClient {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerClient.class);
    private final FastdfsExecutor executor;
    private final TrackerSelector selector;
    private final List<TrackerServer> servers;

    TrackerClient(FastdfsExecutor executor, TrackerSelector selector, List<TrackerServer> servers) {
        this.executor = executor;
        this.servers = Collections.unmodifiableList(servers);
        this.selector = servers.size() == 1 ? TrackerSelector.FIRST : selector;
        LOG.info("TrackerClient inited with {} servers and selector {}.", (Object)servers.size(), (Object)this.selector);
    }

    private InetSocketAddress trackerSelect() {
        return this.selector.select(this.servers).toInetAddress();
    }

    CompletableFuture<StorageServer> uploadStorageGet() {
        return this.uploadStorageGet(null);
    }

    CompletableFuture<StorageServer> uploadStorageGet(String group) {
        return this.executor.execute(this.trackerSelect(), (Requestor.Encoder)new UploadStorageGetEncoder(group), StorageServerDecoder.INSTANCE);
    }

    CompletableFuture<StorageServer> downloadStorageGet(FileId fileId) {
        CompletableFuture<List<StorageServer>> result = this.executor.execute(this.trackerSelect(), (Requestor.Encoder)new DownloadStorageGetEncoder(fileId), StorageServerListDecoder.INSTANCE);
        return result.thenApply(FastdfsUtils::first);
    }

    CompletableFuture<StorageServer> updateStorageGet(FileId fileId) {
        CompletableFuture<List<StorageServer>> result = this.executor.execute(this.trackerSelect(), (Requestor.Encoder)new UpdateStorageGetEncoder(fileId), StorageServerListDecoder.INSTANCE);
        return result.thenApply(FastdfsUtils::first);
    }

    CompletableFuture<List<StorageServer>> downloadStorageList(FileId fileId) {
        return this.executor.execute(this.trackerSelect(), (Requestor.Encoder)new DownloadStorageListEncoder(fileId), StorageServerListDecoder.INSTANCE);
    }
}

