/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileOperationEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;

public class FileAppendEncoder
extends FileOperationEncoder {
    private final FileId fileId;

    public FileAppendEncoder(FileId fileId, File file) {
        super(file);
        this.fileId = fileId;
    }

    public FileAppendEncoder(FileId fileId, Object content, long size) {
        super(content, size);
        this.fileId = fileId;
    }

    @Override
    protected byte cmd() {
        return 24;
    }

    @Override
    protected ByteBuf metadata(ByteBufAllocator alloc) {
        byte[] pathBytes = this.fileId.pathBytes();
        int metaSize = 16 + pathBytes.length;
        ByteBuf buf = alloc.buffer(metaSize);
        buf.writeLong((long)pathBytes.length);
        buf.writeLong(this.size());
        buf.writeBytes(pathBytes);
        return buf;
    }
}

