/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.Collections;
import java.util.List;

public class FileDownloadEncoder
implements Requestor.Encoder {
    private static final long DEFAULT_OFFSET = 0L;
    private static final long SIZE_UNLIMIT = 0L;
    private final FileId fileId;
    private final long offset;
    private final long size;

    public FileDownloadEncoder(FileId fileId) {
        this(fileId, 0L, 0L);
    }

    public FileDownloadEncoder(FileId fileId, long offset, long size) {
        this.fileId = fileId;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public List<Object> encode(ByteBufAllocator alloc) {
        byte[] pathBytes = this.fileId.pathBytes();
        int length = 32 + pathBytes.length;
        int cmd = 14;
        ByteBuf buf = alloc.buffer(length + 10);
        buf.writeLong((long)length);
        buf.writeByte(cmd);
        buf.writeByte(0);
        buf.writeLong(this.offset);
        buf.writeLong(this.size);
        FastdfsUtils.writeFixLength(buf, this.fileId.group(), 16);
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)this.fileId.path());
        return Collections.singletonList(buf);
    }
}

