/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import io.netty.buffer.ByteBuf;

public enum FileIdDecoder implements Replier.Decoder<FileId>
{
    INSTANCE;


    @Override
    public FileId decode(ByteBuf in) {
        int length = in.readableBytes();
        if (length <= 16) {
            throw new FastdfsException("body length : " + length + ", is lte required group name length 16.");
        }
        String group = FastdfsUtils.readString(in, 16);
        String path = FastdfsUtils.readString(in);
        return new FileId(group, path);
    }
}

